<?php

namespace PPAPI\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Souscription ServiceType
 * @subpackage Services
 */
class Souscription extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named souscriptionDevis
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \PPAPI\StructType\SouscriptionDevis $parameters
     * @return \PPAPI\StructType\SouscriptionDevisResponse|bool
     */
    public function souscriptionDevis(\PPAPI\StructType\SouscriptionDevis $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->souscriptionDevis($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \PPAPI\StructType\SouscriptionDevisResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
