<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MakeCallResponse StructType
 * @subpackage Structs
 */
class MakeCallResponse extends AbstractStructBase
{
    /**
     * The MakeCallResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MakeCallResult;
    /**
     * Constructor method for MakeCallResponse
     * @uses MakeCallResponse::setMakeCallResult()
     * @param string $makeCallResult
     */
    public function __construct($makeCallResult = null)
    {
        $this
            ->setMakeCallResult($makeCallResult);
    }
    /**
     * Get MakeCallResult value
     * @return string|null
     */
    public function getMakeCallResult()
    {
        return $this->MakeCallResult;
    }
    /**
     * Set MakeCallResult value
     * @param string $makeCallResult
     * @return \StructType\MakeCallResponse
     */
    public function setMakeCallResult($makeCallResult = null)
    {
        // validation for constraint: pattern
        if (is_scalar($makeCallResult) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $makeCallResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($makeCallResult, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($makeCallResult) && !is_string($makeCallResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($makeCallResult)), __LINE__);
        }
        $this->MakeCallResult = $makeCallResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MakeCallResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
