<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MakeCall StructType
 * @subpackage Structs
 */
class MakeCall extends AbstractStructBase
{
    /**
     * The contact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contact
     */
    public $contact;
    /**
     * Constructor method for MakeCall
     * @uses MakeCall::setContact()
     * @param \StructType\Contact $contact
     */
    public function __construct(\StructType\Contact $contact = null)
    {
        $this
            ->setContact($contact);
    }
    /**
     * Get contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contact|null
     */
    public function getContact()
    {
        return isset($this->contact) ? $this->contact : null;
    }
    /**
     * Set contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Contact $contact
     * @return \StructType\MakeCall
     */
    public function setContact(\StructType\Contact $contact = null)
    {
        if (is_null($contact) || (is_array($contact) && empty($contact))) {
            unset($this->contact);
        } else {
            $this->contact = $contact;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MakeCall
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
