<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactNumber StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ContactNumber
 * @subpackage Structs
 */
class ContactNumber extends AbstractStructBase
{
    /**
     * The OrderIndex
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OrderIndex;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhoneNumber;
    /**
     * Constructor method for ContactNumber
     * @uses ContactNumber::setOrderIndex()
     * @uses ContactNumber::setPhoneNumber()
     * @param int $orderIndex
     * @param string $phoneNumber
     */
    public function __construct($orderIndex = null, $phoneNumber = null)
    {
        $this
            ->setOrderIndex($orderIndex)
            ->setPhoneNumber($phoneNumber);
    }
    /**
     * Get OrderIndex value
     * @return int|null
     */
    public function getOrderIndex()
    {
        return $this->OrderIndex;
    }
    /**
     * Set OrderIndex value
     * @param int $orderIndex
     * @return \StructType\ContactNumber
     */
    public function setOrderIndex($orderIndex = null)
    {
        // validation for constraint: int
        if (!is_null($orderIndex) && !is_numeric($orderIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderIndex)), __LINE__);
        }
        $this->OrderIndex = $orderIndex;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return isset($this->PhoneNumber) ? $this->PhoneNumber : null;
    }
    /**
     * Set PhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phoneNumber
     * @return \StructType\ContactNumber
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        if (is_null($phoneNumber) || (is_array($phoneNumber) && empty($phoneNumber))) {
            unset($this->PhoneNumber);
        } else {
            $this->PhoneNumber = $phoneNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContactNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
