<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Callflow StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Callflow
 * @subpackage Structs
 */
class Callflow extends AbstractStructBase
{
    /**
     * The CallerLineIdentities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCallerLineIdentity
     */
    public $CallerLineIdentities;
    /**
     * The CallflowId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CallflowId;
    /**
     * The Parameters
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Parameters;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The TransferNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTransferNumber
     */
    public $TransferNumbers;
    /**
     * Constructor method for Callflow
     * @uses Callflow::setCallerLineIdentities()
     * @uses Callflow::setCallflowId()
     * @uses Callflow::setParameters()
     * @uses Callflow::setTitle()
     * @uses Callflow::setTransferNumbers()
     * @param \ArrayType\ArrayOfCallerLineIdentity $callerLineIdentities
     * @param string $callflowId
     * @param \ArrayType\ArrayOfstring $parameters
     * @param string $title
     * @param \ArrayType\ArrayOfTransferNumber $transferNumbers
     */
    public function __construct(\ArrayType\ArrayOfCallerLineIdentity $callerLineIdentities = null, $callflowId = null, \ArrayType\ArrayOfstring $parameters = null, $title = null, \ArrayType\ArrayOfTransferNumber $transferNumbers = null)
    {
        $this
            ->setCallerLineIdentities($callerLineIdentities)
            ->setCallflowId($callflowId)
            ->setParameters($parameters)
            ->setTitle($title)
            ->setTransferNumbers($transferNumbers);
    }
    /**
     * Get CallerLineIdentities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCallerLineIdentity|null
     */
    public function getCallerLineIdentities()
    {
        return isset($this->CallerLineIdentities) ? $this->CallerLineIdentities : null;
    }
    /**
     * Set CallerLineIdentities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCallerLineIdentity $callerLineIdentities
     * @return \StructType\Callflow
     */
    public function setCallerLineIdentities(\ArrayType\ArrayOfCallerLineIdentity $callerLineIdentities = null)
    {
        if (is_null($callerLineIdentities) || (is_array($callerLineIdentities) && empty($callerLineIdentities))) {
            unset($this->CallerLineIdentities);
        } else {
            $this->CallerLineIdentities = $callerLineIdentities;
        }
        return $this;
    }
    /**
     * Get CallflowId value
     * @return string|null
     */
    public function getCallflowId()
    {
        return $this->CallflowId;
    }
    /**
     * Set CallflowId value
     * @param string $callflowId
     * @return \StructType\Callflow
     */
    public function setCallflowId($callflowId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($callflowId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $callflowId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($callflowId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callflowId) && !is_string($callflowId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callflowId)), __LINE__);
        }
        $this->CallflowId = $callflowId;
        return $this;
    }
    /**
     * Get Parameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getParameters()
    {
        return isset($this->Parameters) ? $this->Parameters : null;
    }
    /**
     * Set Parameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $parameters
     * @return \StructType\Callflow
     */
    public function setParameters(\ArrayType\ArrayOfstring $parameters = null)
    {
        if (is_null($parameters) || (is_array($parameters) && empty($parameters))) {
            unset($this->Parameters);
        } else {
            $this->Parameters = $parameters;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \StructType\Callflow
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Get TransferNumbers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTransferNumber|null
     */
    public function getTransferNumbers()
    {
        return isset($this->TransferNumbers) ? $this->TransferNumbers : null;
    }
    /**
     * Set TransferNumbers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTransferNumber $transferNumbers
     * @return \StructType\Callflow
     */
    public function setTransferNumbers(\ArrayType\ArrayOfTransferNumber $transferNumbers = null)
    {
        if (is_null($transferNumbers) || (is_array($transferNumbers) && empty($transferNumbers))) {
            unset($this->TransferNumbers);
        } else {
            $this->TransferNumbers = $transferNumbers;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Callflow
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
