<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTransferNumber ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfTransferNumber
 * @subpackage Arrays
 */
class ArrayOfTransferNumber extends AbstractStructArrayBase
{
    /**
     * The TransferNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TransferNumber[]
     */
    public $TransferNumber;
    /**
     * Constructor method for ArrayOfTransferNumber
     * @uses ArrayOfTransferNumber::setTransferNumber()
     * @param \StructType\TransferNumber[] $transferNumber
     */
    public function __construct(array $transferNumber = array())
    {
        $this
            ->setTransferNumber($transferNumber);
    }
    /**
     * Get TransferNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TransferNumber[]|null
     */
    public function getTransferNumber()
    {
        return isset($this->TransferNumber) ? $this->TransferNumber : null;
    }
    /**
     * Set TransferNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TransferNumber[] $transferNumber
     * @return \ArrayType\ArrayOfTransferNumber
     */
    public function setTransferNumber(array $transferNumber = array())
    {
        foreach ($transferNumber as $arrayOfTransferNumberTransferNumberItem) {
            // validation for constraint: itemType
            if (!$arrayOfTransferNumberTransferNumberItem instanceof \StructType\TransferNumber) {
                throw new \InvalidArgumentException(sprintf('The TransferNumber property can only contain items of \StructType\TransferNumber, "%s" given', is_object($arrayOfTransferNumberTransferNumberItem) ? get_class($arrayOfTransferNumberTransferNumberItem) : gettype($arrayOfTransferNumberTransferNumberItem)), __LINE__);
            }
        }
        if (is_null($transferNumber) || (is_array($transferNumber) && empty($transferNumber))) {
            unset($this->TransferNumber);
        } else {
            $this->TransferNumber = $transferNumber;
        }
        return $this;
    }
    /**
     * Add item to TransferNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\TransferNumber $item
     * @return \ArrayType\ArrayOfTransferNumber
     */
    public function addToTransferNumber(\StructType\TransferNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransferNumber) {
            throw new \InvalidArgumentException(sprintf('The TransferNumber property can only contain items of \StructType\TransferNumber, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TransferNumber[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TransferNumber|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TransferNumber|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TransferNumber|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TransferNumber|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TransferNumber|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TransferNumber
     */
    public function getAttributeName()
    {
        return 'TransferNumber';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTransferNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
