<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContactVariable ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfContactVariable
 * @subpackage Arrays
 */
class ArrayOfContactVariable extends AbstractStructArrayBase
{
    /**
     * The ContactVariable
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContactVariable[]
     */
    public $ContactVariable;
    /**
     * Constructor method for ArrayOfContactVariable
     * @uses ArrayOfContactVariable::setContactVariable()
     * @param \StructType\ContactVariable[] $contactVariable
     */
    public function __construct(array $contactVariable = array())
    {
        $this
            ->setContactVariable($contactVariable);
    }
    /**
     * Get ContactVariable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContactVariable[]|null
     */
    public function getContactVariable()
    {
        return isset($this->ContactVariable) ? $this->ContactVariable : null;
    }
    /**
     * Set ContactVariable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContactVariable[] $contactVariable
     * @return \ArrayType\ArrayOfContactVariable
     */
    public function setContactVariable(array $contactVariable = array())
    {
        foreach ($contactVariable as $arrayOfContactVariableContactVariableItem) {
            // validation for constraint: itemType
            if (!$arrayOfContactVariableContactVariableItem instanceof \StructType\ContactVariable) {
                throw new \InvalidArgumentException(sprintf('The ContactVariable property can only contain items of \StructType\ContactVariable, "%s" given', is_object($arrayOfContactVariableContactVariableItem) ? get_class($arrayOfContactVariableContactVariableItem) : gettype($arrayOfContactVariableContactVariableItem)), __LINE__);
            }
        }
        if (is_null($contactVariable) || (is_array($contactVariable) && empty($contactVariable))) {
            unset($this->ContactVariable);
        } else {
            $this->ContactVariable = $contactVariable;
        }
        return $this;
    }
    /**
     * Add item to ContactVariable value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactVariable $item
     * @return \ArrayType\ArrayOfContactVariable
     */
    public function addToContactVariable(\StructType\ContactVariable $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactVariable) {
            throw new \InvalidArgumentException(sprintf('The ContactVariable property can only contain items of \StructType\ContactVariable, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactVariable[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ContactVariable|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ContactVariable|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ContactVariable|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ContactVariable|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ContactVariable|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContactVariable
     */
    public function getAttributeName()
    {
        return 'ContactVariable';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfContactVariable
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
