<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContactNumber ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfContactNumber
 * @subpackage Arrays
 */
class ArrayOfContactNumber extends AbstractStructArrayBase
{
    /**
     * The ContactNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContactNumber[]
     */
    public $ContactNumber;
    /**
     * Constructor method for ArrayOfContactNumber
     * @uses ArrayOfContactNumber::setContactNumber()
     * @param \StructType\ContactNumber[] $contactNumber
     */
    public function __construct(array $contactNumber = array())
    {
        $this
            ->setContactNumber($contactNumber);
    }
    /**
     * Get ContactNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContactNumber[]|null
     */
    public function getContactNumber()
    {
        return isset($this->ContactNumber) ? $this->ContactNumber : null;
    }
    /**
     * Set ContactNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContactNumber[] $contactNumber
     * @return \ArrayType\ArrayOfContactNumber
     */
    public function setContactNumber(array $contactNumber = array())
    {
        foreach ($contactNumber as $arrayOfContactNumberContactNumberItem) {
            // validation for constraint: itemType
            if (!$arrayOfContactNumberContactNumberItem instanceof \StructType\ContactNumber) {
                throw new \InvalidArgumentException(sprintf('The ContactNumber property can only contain items of \StructType\ContactNumber, "%s" given', is_object($arrayOfContactNumberContactNumberItem) ? get_class($arrayOfContactNumberContactNumberItem) : gettype($arrayOfContactNumberContactNumberItem)), __LINE__);
            }
        }
        if (is_null($contactNumber) || (is_array($contactNumber) && empty($contactNumber))) {
            unset($this->ContactNumber);
        } else {
            $this->ContactNumber = $contactNumber;
        }
        return $this;
    }
    /**
     * Add item to ContactNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactNumber $item
     * @return \ArrayType\ArrayOfContactNumber
     */
    public function addToContactNumber(\StructType\ContactNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactNumber) {
            throw new \InvalidArgumentException(sprintf('The ContactNumber property can only contain items of \StructType\ContactNumber, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactNumber[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ContactNumber|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ContactNumber|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ContactNumber|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ContactNumber|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ContactNumber|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContactNumber
     */
    public function getAttributeName()
    {
        return 'ContactNumber';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfContactNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
