<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.collstream.co.uk/Voice/v1_0/CollstreamVoiceService.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.collstream.co.uk/Voice/v1_0/CollstreamVoiceService.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for CreateCampaign operation/method
 */
if ($create->CreateCampaign(new \StructType\CreateCampaign()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddContact operation/method
 */
if ($add->AddContact(new \StructType\AddContact()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Schedule ServiceType
 */
$schedule = new \ServiceType\Schedule($options);
/**
 * Sample call for ScheduleContact operation/method
 */
if ($schedule->ScheduleContact(new \StructType\ScheduleContact()) !== false) {
    print_r($schedule->getResult());
} else {
    print_r($schedule->getLastError());
}
/**
 * Sample call for ScheduleCall operation/method
 */
if ($schedule->ScheduleCall(new \StructType\ScheduleCall()) !== false) {
    print_r($schedule->getResult());
} else {
    print_r($schedule->getLastError());
}
/**
 * Samples for Make ServiceType
 */
$make = new \ServiceType\Make($options);
/**
 * Sample call for MakeCall operation/method
 */
if ($make->MakeCall(new \StructType\MakeCall()) !== false) {
    print_r($make->getResult());
} else {
    print_r($make->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetCallflows operation/method
 */
if ($get->GetCallflows(new \StructType\GetCallflows()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
