<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScheduleCall StructType
 * @subpackage Structs
 */
class ScheduleCall extends AbstractStructBase
{
    /**
     * The contact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contact
     */
    public $contact;
    /**
     * The whenToMakeCall
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $whenToMakeCall;
    /**
     * Constructor method for ScheduleCall
     * @uses ScheduleCall::setContact()
     * @uses ScheduleCall::setWhenToMakeCall()
     * @param \StructType\Contact $contact
     * @param string $whenToMakeCall
     */
    public function __construct(\StructType\Contact $contact = null, $whenToMakeCall = null)
    {
        $this
            ->setContact($contact)
            ->setWhenToMakeCall($whenToMakeCall);
    }
    /**
     * Get contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contact|null
     */
    public function getContact()
    {
        return isset($this->contact) ? $this->contact : null;
    }
    /**
     * Set contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Contact $contact
     * @return \StructType\ScheduleCall
     */
    public function setContact(\StructType\Contact $contact = null)
    {
        if (is_null($contact) || (is_array($contact) && empty($contact))) {
            unset($this->contact);
        } else {
            $this->contact = $contact;
        }
        return $this;
    }
    /**
     * Get whenToMakeCall value
     * @return string|null
     */
    public function getWhenToMakeCall()
    {
        return $this->whenToMakeCall;
    }
    /**
     * Set whenToMakeCall value
     * @param string $whenToMakeCall
     * @return \StructType\ScheduleCall
     */
    public function setWhenToMakeCall($whenToMakeCall = null)
    {
        // validation for constraint: string
        if (!is_null($whenToMakeCall) && !is_string($whenToMakeCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($whenToMakeCall)), __LINE__);
        }
        $this->whenToMakeCall = $whenToMakeCall;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ScheduleCall
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
