<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateCampaignResponse StructType
 * @subpackage Structs
 */
class CreateCampaignResponse extends AbstractStructBase
{
    /**
     * The CreateCampaignResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreateCampaignResult;
    /**
     * Constructor method for CreateCampaignResponse
     * @uses CreateCampaignResponse::setCreateCampaignResult()
     * @param string $createCampaignResult
     */
    public function __construct($createCampaignResult = null)
    {
        $this
            ->setCreateCampaignResult($createCampaignResult);
    }
    /**
     * Get CreateCampaignResult value
     * @return string|null
     */
    public function getCreateCampaignResult()
    {
        return $this->CreateCampaignResult;
    }
    /**
     * Set CreateCampaignResult value
     * @param string $createCampaignResult
     * @return \StructType\CreateCampaignResponse
     */
    public function setCreateCampaignResult($createCampaignResult = null)
    {
        // validation for constraint: pattern
        if (is_scalar($createCampaignResult) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $createCampaignResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($createCampaignResult, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($createCampaignResult) && !is_string($createCampaignResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createCampaignResult)), __LINE__);
        }
        $this->CreateCampaignResult = $createCampaignResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateCampaignResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
