<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contact StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Contact
 * @subpackage Structs
 */
class Contact extends AbstractStructBase
{
    /**
     * The ContactId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContactId;
    /**
     * The Numbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfContactNumber
     */
    public $Numbers;
    /**
     * The Variables
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfContactVariable
     */
    public $Variables;
    /**
     * Constructor method for Contact
     * @uses Contact::setContactId()
     * @uses Contact::setNumbers()
     * @uses Contact::setVariables()
     * @param string $contactId
     * @param \ArrayType\ArrayOfContactNumber $numbers
     * @param \ArrayType\ArrayOfContactVariable $variables
     */
    public function __construct($contactId = null, \ArrayType\ArrayOfContactNumber $numbers = null, \ArrayType\ArrayOfContactVariable $variables = null)
    {
        $this
            ->setContactId($contactId)
            ->setNumbers($numbers)
            ->setVariables($variables);
    }
    /**
     * Get ContactId value
     * @return string|null
     */
    public function getContactId()
    {
        return $this->ContactId;
    }
    /**
     * Set ContactId value
     * @param string $contactId
     * @return \StructType\Contact
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($contactId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($contactId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contactId) && !is_string($contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactId)), __LINE__);
        }
        $this->ContactId = $contactId;
        return $this;
    }
    /**
     * Get Numbers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfContactNumber|null
     */
    public function getNumbers()
    {
        return isset($this->Numbers) ? $this->Numbers : null;
    }
    /**
     * Set Numbers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfContactNumber $numbers
     * @return \StructType\Contact
     */
    public function setNumbers(\ArrayType\ArrayOfContactNumber $numbers = null)
    {
        if (is_null($numbers) || (is_array($numbers) && empty($numbers))) {
            unset($this->Numbers);
        } else {
            $this->Numbers = $numbers;
        }
        return $this;
    }
    /**
     * Get Variables value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfContactVariable|null
     */
    public function getVariables()
    {
        return isset($this->Variables) ? $this->Variables : null;
    }
    /**
     * Set Variables value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfContactVariable $variables
     * @return \StructType\Contact
     */
    public function setVariables(\ArrayType\ArrayOfContactVariable $variables = null)
    {
        if (is_null($variables) || (is_array($variables) && empty($variables))) {
            unset($this->Variables);
        } else {
            $this->Variables = $variables;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Contact
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
