<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CallerLineIdentity StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CallerLineIdentity
 * @subpackage Structs
 */
class CallerLineIdentity extends AbstractStructBase
{
    /**
     * The CallerLineIdentityId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CallerLineIdentityId;
    /**
     * The IdentityText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdentityText;
    /**
     * Constructor method for CallerLineIdentity
     * @uses CallerLineIdentity::setCallerLineIdentityId()
     * @uses CallerLineIdentity::setIdentityText()
     * @param string $callerLineIdentityId
     * @param string $identityText
     */
    public function __construct($callerLineIdentityId = null, $identityText = null)
    {
        $this
            ->setCallerLineIdentityId($callerLineIdentityId)
            ->setIdentityText($identityText);
    }
    /**
     * Get CallerLineIdentityId value
     * @return string|null
     */
    public function getCallerLineIdentityId()
    {
        return $this->CallerLineIdentityId;
    }
    /**
     * Set CallerLineIdentityId value
     * @param string $callerLineIdentityId
     * @return \StructType\CallerLineIdentity
     */
    public function setCallerLineIdentityId($callerLineIdentityId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($callerLineIdentityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $callerLineIdentityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($callerLineIdentityId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerLineIdentityId) && !is_string($callerLineIdentityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerLineIdentityId)), __LINE__);
        }
        $this->CallerLineIdentityId = $callerLineIdentityId;
        return $this;
    }
    /**
     * Get IdentityText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentityText()
    {
        return isset($this->IdentityText) ? $this->IdentityText : null;
    }
    /**
     * Set IdentityText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identityText
     * @return \StructType\CallerLineIdentity
     */
    public function setIdentityText($identityText = null)
    {
        // validation for constraint: string
        if (!is_null($identityText) && !is_string($identityText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identityText)), __LINE__);
        }
        if (is_null($identityText) || (is_array($identityText) && empty($identityText))) {
            unset($this->IdentityText);
        } else {
            $this->IdentityText = $identityText;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CallerLineIdentity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
