<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddContactResponse StructType
 * @subpackage Structs
 */
class AddContactResponse extends AbstractStructBase
{
    /**
     * The AddContactResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AddContactResult;
    /**
     * Constructor method for AddContactResponse
     * @uses AddContactResponse::setAddContactResult()
     * @param string $addContactResult
     */
    public function __construct($addContactResult = null)
    {
        $this
            ->setAddContactResult($addContactResult);
    }
    /**
     * Get AddContactResult value
     * @return string|null
     */
    public function getAddContactResult()
    {
        return $this->AddContactResult;
    }
    /**
     * Set AddContactResult value
     * @param string $addContactResult
     * @return \StructType\AddContactResponse
     */
    public function setAddContactResult($addContactResult = null)
    {
        // validation for constraint: pattern
        if (is_scalar($addContactResult) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $addContactResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($addContactResult, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addContactResult) && !is_string($addContactResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addContactResult)), __LINE__);
        }
        $this->AddContactResult = $addContactResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddContactResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
