<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferNumber StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TransferNumber
 * @subpackage Structs
 */
class TransferNumber extends AbstractStructBase
{
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Number;
    /**
     * The OrderPosition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OrderPosition;
    /**
     * Constructor method for TransferNumber
     * @uses TransferNumber::setNumber()
     * @uses TransferNumber::setOrderPosition()
     * @param string $number
     * @param int $orderPosition
     */
    public function __construct($number = null, $orderPosition = null)
    {
        $this
            ->setNumber($number)
            ->setOrderPosition($orderPosition);
    }
    /**
     * Get Number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumber()
    {
        return isset($this->Number) ? $this->Number : null;
    }
    /**
     * Set Number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $number
     * @return \StructType\TransferNumber
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        if (is_null($number) || (is_array($number) && empty($number))) {
            unset($this->Number);
        } else {
            $this->Number = $number;
        }
        return $this;
    }
    /**
     * Get OrderPosition value
     * @return int|null
     */
    public function getOrderPosition()
    {
        return $this->OrderPosition;
    }
    /**
     * Set OrderPosition value
     * @param int $orderPosition
     * @return \StructType\TransferNumber
     */
    public function setOrderPosition($orderPosition = null)
    {
        // validation for constraint: int
        if (!is_null($orderPosition) && !is_numeric($orderPosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderPosition)), __LINE__);
        }
        $this->OrderPosition = $orderPosition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransferNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
