<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScheduleContactResponse StructType
 * @subpackage Structs
 */
class ScheduleContactResponse extends AbstractStructBase
{
    /**
     * The ScheduleContactResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScheduleContactResult;
    /**
     * Constructor method for ScheduleContactResponse
     * @uses ScheduleContactResponse::setScheduleContactResult()
     * @param string $scheduleContactResult
     */
    public function __construct($scheduleContactResult = null)
    {
        $this
            ->setScheduleContactResult($scheduleContactResult);
    }
    /**
     * Get ScheduleContactResult value
     * @return string|null
     */
    public function getScheduleContactResult()
    {
        return $this->ScheduleContactResult;
    }
    /**
     * Set ScheduleContactResult value
     * @param string $scheduleContactResult
     * @return \StructType\ScheduleContactResponse
     */
    public function setScheduleContactResult($scheduleContactResult = null)
    {
        // validation for constraint: pattern
        if (is_scalar($scheduleContactResult) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scheduleContactResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($scheduleContactResult, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($scheduleContactResult) && !is_string($scheduleContactResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduleContactResult)), __LINE__);
        }
        $this->ScheduleContactResult = $scheduleContactResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ScheduleContactResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
