<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScheduleCallResponse StructType
 * @subpackage Structs
 */
class ScheduleCallResponse extends AbstractStructBase
{
    /**
     * The ScheduleCallResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScheduleCallResult;
    /**
     * Constructor method for ScheduleCallResponse
     * @uses ScheduleCallResponse::setScheduleCallResult()
     * @param string $scheduleCallResult
     */
    public function __construct($scheduleCallResult = null)
    {
        $this
            ->setScheduleCallResult($scheduleCallResult);
    }
    /**
     * Get ScheduleCallResult value
     * @return string|null
     */
    public function getScheduleCallResult()
    {
        return $this->ScheduleCallResult;
    }
    /**
     * Set ScheduleCallResult value
     * @param string $scheduleCallResult
     * @return \StructType\ScheduleCallResponse
     */
    public function setScheduleCallResult($scheduleCallResult = null)
    {
        // validation for constraint: pattern
        if (is_scalar($scheduleCallResult) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scheduleCallResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($scheduleCallResult, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($scheduleCallResult) && !is_string($scheduleCallResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduleCallResult)), __LINE__);
        }
        $this->ScheduleCallResult = $scheduleCallResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ScheduleCallResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
