<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateCampaign StructType
 * @subpackage Structs
 */
class CreateCampaign extends AbstractStructBase
{
    /**
     * The title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $title;
    /**
     * The callflowId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $callflowId;
    /**
     * The settings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CampaignSettings
     */
    public $settings;
    /**
     * Constructor method for CreateCampaign
     * @uses CreateCampaign::setTitle()
     * @uses CreateCampaign::setCallflowId()
     * @uses CreateCampaign::setSettings()
     * @param string $title
     * @param string $callflowId
     * @param \StructType\CampaignSettings $settings
     */
    public function __construct($title = null, $callflowId = null, \StructType\CampaignSettings $settings = null)
    {
        $this
            ->setTitle($title)
            ->setCallflowId($callflowId)
            ->setSettings($settings);
    }
    /**
     * Get title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->title) ? $this->title : null;
    }
    /**
     * Set title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \StructType\CreateCampaign
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->title);
        } else {
            $this->title = $title;
        }
        return $this;
    }
    /**
     * Get callflowId value
     * @return string|null
     */
    public function getCallflowId()
    {
        return $this->callflowId;
    }
    /**
     * Set callflowId value
     * @param string $callflowId
     * @return \StructType\CreateCampaign
     */
    public function setCallflowId($callflowId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($callflowId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $callflowId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($callflowId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callflowId) && !is_string($callflowId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callflowId)), __LINE__);
        }
        $this->callflowId = $callflowId;
        return $this;
    }
    /**
     * Get settings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CampaignSettings|null
     */
    public function getSettings()
    {
        return isset($this->settings) ? $this->settings : null;
    }
    /**
     * Set settings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CampaignSettings $settings
     * @return \StructType\CreateCampaign
     */
    public function setSettings(\StructType\CampaignSettings $settings = null)
    {
        if (is_null($settings) || (is_array($settings) && empty($settings))) {
            unset($this->settings);
        } else {
            $this->settings = $settings;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateCampaign
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
