<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignSettings StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CampaignSettings
 * @subpackage Structs
 */
class CampaignSettings extends AbstractStructBase
{
    /**
     * The AnswerphoneOptionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AnswerphoneOptionId;
    /**
     * The BlacklistOptionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BlacklistOptionId;
    /**
     * The CallCascadeOptionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CallCascadeOptionId;
    /**
     * The CallRetryOptionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CallRetryOptionId;
    /**
     * The CallerLineIdentityId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CallerLineIdentityId;
    /**
     * The ConcurrentCalls
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ConcurrentCalls;
    /**
     * The EndingAt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndingAt;
    /**
     * The IsAllowedToRollOver
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAllowedToRollOver;
    /**
     * The MinutesBetweenRetryAttemptsWhenEngaged
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinutesBetweenRetryAttemptsWhenEngaged;
    /**
     * The MinutesBetweenRetryAttemptsWhenNoAnswer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinutesBetweenRetryAttemptsWhenNoAnswer;
    /**
     * The NumberOfAttempts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfAttempts;
    /**
     * The ShouldLeaveAnswerphone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ShouldLeaveAnswerphone;
    /**
     * The StartingAt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartingAt;
    /**
     * Constructor method for CampaignSettings
     * @uses CampaignSettings::setAnswerphoneOptionId()
     * @uses CampaignSettings::setBlacklistOptionId()
     * @uses CampaignSettings::setCallCascadeOptionId()
     * @uses CampaignSettings::setCallRetryOptionId()
     * @uses CampaignSettings::setCallerLineIdentityId()
     * @uses CampaignSettings::setConcurrentCalls()
     * @uses CampaignSettings::setEndingAt()
     * @uses CampaignSettings::setIsAllowedToRollOver()
     * @uses CampaignSettings::setMinutesBetweenRetryAttemptsWhenEngaged()
     * @uses CampaignSettings::setMinutesBetweenRetryAttemptsWhenNoAnswer()
     * @uses CampaignSettings::setNumberOfAttempts()
     * @uses CampaignSettings::setShouldLeaveAnswerphone()
     * @uses CampaignSettings::setStartingAt()
     * @param string $answerphoneOptionId
     * @param string $blacklistOptionId
     * @param string $callCascadeOptionId
     * @param string $callRetryOptionId
     * @param string $callerLineIdentityId
     * @param int $concurrentCalls
     * @param string $endingAt
     * @param bool $isAllowedToRollOver
     * @param int $minutesBetweenRetryAttemptsWhenEngaged
     * @param int $minutesBetweenRetryAttemptsWhenNoAnswer
     * @param int $numberOfAttempts
     * @param bool $shouldLeaveAnswerphone
     * @param string $startingAt
     */
    public function __construct($answerphoneOptionId = null, $blacklistOptionId = null, $callCascadeOptionId = null, $callRetryOptionId = null, $callerLineIdentityId = null, $concurrentCalls = null, $endingAt = null, $isAllowedToRollOver = null, $minutesBetweenRetryAttemptsWhenEngaged = null, $minutesBetweenRetryAttemptsWhenNoAnswer = null, $numberOfAttempts = null, $shouldLeaveAnswerphone = null, $startingAt = null)
    {
        $this
            ->setAnswerphoneOptionId($answerphoneOptionId)
            ->setBlacklistOptionId($blacklistOptionId)
            ->setCallCascadeOptionId($callCascadeOptionId)
            ->setCallRetryOptionId($callRetryOptionId)
            ->setCallerLineIdentityId($callerLineIdentityId)
            ->setConcurrentCalls($concurrentCalls)
            ->setEndingAt($endingAt)
            ->setIsAllowedToRollOver($isAllowedToRollOver)
            ->setMinutesBetweenRetryAttemptsWhenEngaged($minutesBetweenRetryAttemptsWhenEngaged)
            ->setMinutesBetweenRetryAttemptsWhenNoAnswer($minutesBetweenRetryAttemptsWhenNoAnswer)
            ->setNumberOfAttempts($numberOfAttempts)
            ->setShouldLeaveAnswerphone($shouldLeaveAnswerphone)
            ->setStartingAt($startingAt);
    }
    /**
     * Get AnswerphoneOptionId value
     * @return string|null
     */
    public function getAnswerphoneOptionId()
    {
        return $this->AnswerphoneOptionId;
    }
    /**
     * Set AnswerphoneOptionId value
     * @param string $answerphoneOptionId
     * @return \StructType\CampaignSettings
     */
    public function setAnswerphoneOptionId($answerphoneOptionId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($answerphoneOptionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $answerphoneOptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($answerphoneOptionId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($answerphoneOptionId) && !is_string($answerphoneOptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($answerphoneOptionId)), __LINE__);
        }
        $this->AnswerphoneOptionId = $answerphoneOptionId;
        return $this;
    }
    /**
     * Get BlacklistOptionId value
     * @return string|null
     */
    public function getBlacklistOptionId()
    {
        return $this->BlacklistOptionId;
    }
    /**
     * Set BlacklistOptionId value
     * @param string $blacklistOptionId
     * @return \StructType\CampaignSettings
     */
    public function setBlacklistOptionId($blacklistOptionId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($blacklistOptionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $blacklistOptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($blacklistOptionId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($blacklistOptionId) && !is_string($blacklistOptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blacklistOptionId)), __LINE__);
        }
        $this->BlacklistOptionId = $blacklistOptionId;
        return $this;
    }
    /**
     * Get CallCascadeOptionId value
     * @return string|null
     */
    public function getCallCascadeOptionId()
    {
        return $this->CallCascadeOptionId;
    }
    /**
     * Set CallCascadeOptionId value
     * @param string $callCascadeOptionId
     * @return \StructType\CampaignSettings
     */
    public function setCallCascadeOptionId($callCascadeOptionId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($callCascadeOptionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $callCascadeOptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($callCascadeOptionId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callCascadeOptionId) && !is_string($callCascadeOptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callCascadeOptionId)), __LINE__);
        }
        $this->CallCascadeOptionId = $callCascadeOptionId;
        return $this;
    }
    /**
     * Get CallRetryOptionId value
     * @return string|null
     */
    public function getCallRetryOptionId()
    {
        return $this->CallRetryOptionId;
    }
    /**
     * Set CallRetryOptionId value
     * @param string $callRetryOptionId
     * @return \StructType\CampaignSettings
     */
    public function setCallRetryOptionId($callRetryOptionId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($callRetryOptionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $callRetryOptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($callRetryOptionId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callRetryOptionId) && !is_string($callRetryOptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callRetryOptionId)), __LINE__);
        }
        $this->CallRetryOptionId = $callRetryOptionId;
        return $this;
    }
    /**
     * Get CallerLineIdentityId value
     * @return string|null
     */
    public function getCallerLineIdentityId()
    {
        return $this->CallerLineIdentityId;
    }
    /**
     * Set CallerLineIdentityId value
     * @param string $callerLineIdentityId
     * @return \StructType\CampaignSettings
     */
    public function setCallerLineIdentityId($callerLineIdentityId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($callerLineIdentityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $callerLineIdentityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($callerLineIdentityId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerLineIdentityId) && !is_string($callerLineIdentityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerLineIdentityId)), __LINE__);
        }
        $this->CallerLineIdentityId = $callerLineIdentityId;
        return $this;
    }
    /**
     * Get ConcurrentCalls value
     * @return int|null
     */
    public function getConcurrentCalls()
    {
        return $this->ConcurrentCalls;
    }
    /**
     * Set ConcurrentCalls value
     * @param int $concurrentCalls
     * @return \StructType\CampaignSettings
     */
    public function setConcurrentCalls($concurrentCalls = null)
    {
        // validation for constraint: int
        if (!is_null($concurrentCalls) && !is_numeric($concurrentCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($concurrentCalls)), __LINE__);
        }
        $this->ConcurrentCalls = $concurrentCalls;
        return $this;
    }
    /**
     * Get EndingAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndingAt()
    {
        return isset($this->EndingAt) ? $this->EndingAt : null;
    }
    /**
     * Set EndingAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endingAt
     * @return \StructType\CampaignSettings
     */
    public function setEndingAt($endingAt = null)
    {
        // validation for constraint: string
        if (!is_null($endingAt) && !is_string($endingAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endingAt)), __LINE__);
        }
        if (is_null($endingAt) || (is_array($endingAt) && empty($endingAt))) {
            unset($this->EndingAt);
        } else {
            $this->EndingAt = $endingAt;
        }
        return $this;
    }
    /**
     * Get IsAllowedToRollOver value
     * @return bool|null
     */
    public function getIsAllowedToRollOver()
    {
        return $this->IsAllowedToRollOver;
    }
    /**
     * Set IsAllowedToRollOver value
     * @param bool $isAllowedToRollOver
     * @return \StructType\CampaignSettings
     */
    public function setIsAllowedToRollOver($isAllowedToRollOver = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAllowedToRollOver) && !is_bool($isAllowedToRollOver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAllowedToRollOver)), __LINE__);
        }
        $this->IsAllowedToRollOver = $isAllowedToRollOver;
        return $this;
    }
    /**
     * Get MinutesBetweenRetryAttemptsWhenEngaged value
     * @return int|null
     */
    public function getMinutesBetweenRetryAttemptsWhenEngaged()
    {
        return $this->MinutesBetweenRetryAttemptsWhenEngaged;
    }
    /**
     * Set MinutesBetweenRetryAttemptsWhenEngaged value
     * @param int $minutesBetweenRetryAttemptsWhenEngaged
     * @return \StructType\CampaignSettings
     */
    public function setMinutesBetweenRetryAttemptsWhenEngaged($minutesBetweenRetryAttemptsWhenEngaged = null)
    {
        // validation for constraint: int
        if (!is_null($minutesBetweenRetryAttemptsWhenEngaged) && !is_numeric($minutesBetweenRetryAttemptsWhenEngaged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minutesBetweenRetryAttemptsWhenEngaged)), __LINE__);
        }
        $this->MinutesBetweenRetryAttemptsWhenEngaged = $minutesBetweenRetryAttemptsWhenEngaged;
        return $this;
    }
    /**
     * Get MinutesBetweenRetryAttemptsWhenNoAnswer value
     * @return int|null
     */
    public function getMinutesBetweenRetryAttemptsWhenNoAnswer()
    {
        return $this->MinutesBetweenRetryAttemptsWhenNoAnswer;
    }
    /**
     * Set MinutesBetweenRetryAttemptsWhenNoAnswer value
     * @param int $minutesBetweenRetryAttemptsWhenNoAnswer
     * @return \StructType\CampaignSettings
     */
    public function setMinutesBetweenRetryAttemptsWhenNoAnswer($minutesBetweenRetryAttemptsWhenNoAnswer = null)
    {
        // validation for constraint: int
        if (!is_null($minutesBetweenRetryAttemptsWhenNoAnswer) && !is_numeric($minutesBetweenRetryAttemptsWhenNoAnswer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minutesBetweenRetryAttemptsWhenNoAnswer)), __LINE__);
        }
        $this->MinutesBetweenRetryAttemptsWhenNoAnswer = $minutesBetweenRetryAttemptsWhenNoAnswer;
        return $this;
    }
    /**
     * Get NumberOfAttempts value
     * @return int|null
     */
    public function getNumberOfAttempts()
    {
        return $this->NumberOfAttempts;
    }
    /**
     * Set NumberOfAttempts value
     * @param int $numberOfAttempts
     * @return \StructType\CampaignSettings
     */
    public function setNumberOfAttempts($numberOfAttempts = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfAttempts) && !is_numeric($numberOfAttempts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfAttempts)), __LINE__);
        }
        $this->NumberOfAttempts = $numberOfAttempts;
        return $this;
    }
    /**
     * Get ShouldLeaveAnswerphone value
     * @return bool|null
     */
    public function getShouldLeaveAnswerphone()
    {
        return $this->ShouldLeaveAnswerphone;
    }
    /**
     * Set ShouldLeaveAnswerphone value
     * @param bool $shouldLeaveAnswerphone
     * @return \StructType\CampaignSettings
     */
    public function setShouldLeaveAnswerphone($shouldLeaveAnswerphone = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldLeaveAnswerphone) && !is_bool($shouldLeaveAnswerphone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($shouldLeaveAnswerphone)), __LINE__);
        }
        $this->ShouldLeaveAnswerphone = $shouldLeaveAnswerphone;
        return $this;
    }
    /**
     * Get StartingAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartingAt()
    {
        return isset($this->StartingAt) ? $this->StartingAt : null;
    }
    /**
     * Set StartingAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startingAt
     * @return \StructType\CampaignSettings
     */
    public function setStartingAt($startingAt = null)
    {
        // validation for constraint: string
        if (!is_null($startingAt) && !is_string($startingAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startingAt)), __LINE__);
        }
        if (is_null($startingAt) || (is_array($startingAt) && empty($startingAt))) {
            unset($this->StartingAt);
        } else {
            $this->StartingAt = $startingAt;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CampaignSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
