<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Schedule ServiceType
 * @subpackage Services
 */
class Schedule extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ScheduleContact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ScheduleContact $parameters
     * @return \StructType\ScheduleContactResponse|bool
     */
    public function ScheduleContact(\StructType\ScheduleContact $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ScheduleContact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ScheduleCall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ScheduleCall $parameters
     * @return \StructType\ScheduleCallResponse|bool
     */
    public function ScheduleCall(\StructType\ScheduleCall $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ScheduleCall($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ScheduleCallResponse|\StructType\ScheduleContactResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
