<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getThirdParty
     * Meta informations extracted from the WSDL
     * - documentation: WS to get a thirdparty from its id, ref or ref_ext
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Authentication $authentication
     * @param string $id
     * @param string $ref
     * @param string $ref_ext
     * @return array|bool
     */
    public function getThirdParty(\StructType\Authentication $authentication, $id, $ref, $ref_ext)
    {
        try {
            $this->setResult(self::getSoapClient()->getThirdParty($authentication, $id, $ref, $ref_ext));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getListOfThirdParties
     * Meta informations extracted from the WSDL
     * - documentation: WS to get list of thirdparties id and ref
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Authentication $authentication
     * @param \StructType\Filterthirdparty $filterthirdparty
     * @return array|bool
     */
    public function getListOfThirdParties(\StructType\Authentication $authentication, \StructType\Filterthirdparty $filterthirdparty)
    {
        try {
            $this->setResult(self::getSoapClient()->getListOfThirdParties($authentication, $filterthirdparty));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
