<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for result StructType
 * @subpackage Structs
 */
class Result extends AbstractStructBase
{
    /**
     * The result_code
     * @var string
     */
    public $result_code;
    /**
     * The result_label
     * @var string
     */
    public $result_label;
    /**
     * Constructor method for result
     * @uses Result::setResult_code()
     * @uses Result::setResult_label()
     * @param string $result_code
     * @param string $result_label
     */
    public function __construct($result_code = null, $result_label = null)
    {
        $this
            ->setResult_code($result_code)
            ->setResult_label($result_label);
    }
    /**
     * Get result_code value
     * @return string|null
     */
    public function getResult_code()
    {
        return $this->result_code;
    }
    /**
     * Set result_code value
     * @param string $result_code
     * @return \StructType\Result
     */
    public function setResult_code($result_code = null)
    {
        // validation for constraint: string
        if (!is_null($result_code) && !is_string($result_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($result_code)), __LINE__);
        }
        $this->result_code = $result_code;
        return $this;
    }
    /**
     * Get result_label value
     * @return string|null
     */
    public function getResult_label()
    {
        return $this->result_label;
    }
    /**
     * Set result_label value
     * @param string $result_label
     * @return \StructType\Result
     */
    public function setResult_label($result_label = null)
    {
        // validation for constraint: string
        if (!is_null($result_label) && !is_string($result_label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($result_label)), __LINE__);
        }
        $this->result_label = $result_label;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Result
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
