<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for filterthirdparty StructType
 * @subpackage Structs
 */
class Filterthirdparty extends AbstractStructBase
{
    /**
     * The client
     * @var string
     */
    public $client;
    /**
     * The supplier
     * @var string
     */
    public $supplier;
    /**
     * The category
     * @var string
     */
    public $category;
    /**
     * Constructor method for filterthirdparty
     * @uses Filterthirdparty::setClient()
     * @uses Filterthirdparty::setSupplier()
     * @uses Filterthirdparty::setCategory()
     * @param string $client
     * @param string $supplier
     * @param string $category
     */
    public function __construct($client = null, $supplier = null, $category = null)
    {
        $this
            ->setClient($client)
            ->setSupplier($supplier)
            ->setCategory($category);
    }
    /**
     * Get client value
     * @return string|null
     */
    public function getClient()
    {
        return $this->client;
    }
    /**
     * Set client value
     * @param string $client
     * @return \StructType\Filterthirdparty
     */
    public function setClient($client = null)
    {
        // validation for constraint: string
        if (!is_null($client) && !is_string($client)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($client)), __LINE__);
        }
        $this->client = $client;
        return $this;
    }
    /**
     * Get supplier value
     * @return string|null
     */
    public function getSupplier()
    {
        return $this->supplier;
    }
    /**
     * Set supplier value
     * @param string $supplier
     * @return \StructType\Filterthirdparty
     */
    public function setSupplier($supplier = null)
    {
        // validation for constraint: string
        if (!is_null($supplier) && !is_string($supplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supplier)), __LINE__);
        }
        $this->supplier = $supplier;
        return $this;
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\Filterthirdparty
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Filterthirdparty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
