<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ThirdPartiesArray2 ArrayType
 * @subpackage Arrays
 */
class ThirdPartiesArray2 extends AbstractStructArrayBase
{
    /**
     * The thirdparty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Thirdparty[]
     */
    public $thirdparty;
    /**
     * Constructor method for ThirdPartiesArray2
     * @uses ThirdPartiesArray2::setThirdparty()
     * @param \StructType\Thirdparty[] $thirdparty
     */
    public function __construct(array $thirdparty = array())
    {
        $this
            ->setThirdparty($thirdparty);
    }
    /**
     * Get thirdparty value
     * @return \StructType\Thirdparty[]|null
     */
    public function getThirdparty()
    {
        return $this->thirdparty;
    }
    /**
     * Set thirdparty value
     * @throws \InvalidArgumentException
     * @param \StructType\Thirdparty[] $thirdparty
     * @return \ArrayType\ThirdPartiesArray2
     */
    public function setThirdparty(array $thirdparty = array())
    {
        foreach ($thirdparty as $thirdPartiesArray2ThirdpartyItem) {
            // validation for constraint: itemType
            if (!$thirdPartiesArray2ThirdpartyItem instanceof \StructType\Thirdparty) {
                throw new \InvalidArgumentException(sprintf('The thirdparty property can only contain items of \StructType\Thirdparty, "%s" given', is_object($thirdPartiesArray2ThirdpartyItem) ? get_class($thirdPartiesArray2ThirdpartyItem) : gettype($thirdPartiesArray2ThirdpartyItem)), __LINE__);
            }
        }
        $this->thirdparty = $thirdparty;
        return $this;
    }
    /**
     * Add item to thirdparty value
     * @throws \InvalidArgumentException
     * @param \StructType\Thirdparty $item
     * @return \ArrayType\ThirdPartiesArray2
     */
    public function addToThirdparty(\StructType\Thirdparty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Thirdparty) {
            throw new \InvalidArgumentException(sprintf('The thirdparty property can only contain items of \StructType\Thirdparty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->thirdparty[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Thirdparty|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Thirdparty|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Thirdparty|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Thirdparty|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Thirdparty|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string thirdparty
     */
    public function getAttributeName()
    {
        return 'thirdparty';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ThirdPartiesArray2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
