<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 * @Author CybernatiC
 * @Version 0.2
 * @Date 17.12.2017
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CheckTransaction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckTransactionArguments $arguments
     * @return \StructType\CheckTransactionResult|bool
     */
    public function CheckTransaction(\StructType\CheckTransactionArguments $arguments)
    {
        try {
            $this->setResult(self::getSoapClient()->CheckTransaction($arguments));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CheckTransactionResult
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
