<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStatementResult StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetStatementResult
 * @subpackage Structs
 * @Author CybernatiC
 * @Version 0.2
 * @Date 17.12.2017
 */
class GetStatementResult extends GenericResult
{
    /**
     * The statements
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TransactionStatement[]
     */
    public $statements;
    /**
     * Constructor method for GetStatementResult
     * @uses GetStatementResult::setStatements()
     * @param \StructType\TransactionStatement[] $statements
     */
    public function __construct(array $statements = array())
    {
        $this
            ->setStatements($statements);
    }
    /**
     * Get statements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TransactionStatement[]|null
     */
    public function getStatements()
    {
        return isset($this->statements) ? $this->statements : null;
    }
    /**
     * Set statements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionStatement[] $statements
     * @return \StructType\GetStatementResult
     */
    public function setStatements(array $statements = array())
    {
        foreach ($statements as $getStatementResultStatementsItem) {
            // validation for constraint: itemType
            if (!$getStatementResultStatementsItem instanceof \StructType\TransactionStatement) {
                throw new \InvalidArgumentException(sprintf('The statements property can only contain items of \StructType\TransactionStatement, "%s" given', is_object($getStatementResultStatementsItem) ? get_class($getStatementResultStatementsItem) : gettype($getStatementResultStatementsItem)), __LINE__);
            }
        }
        if (is_null($statements) || (is_array($statements) && empty($statements))) {
            unset($this->statements);
        } else {
            $this->statements = $statements;
        }
        return $this;
    }
    /**
     * Add item to statements value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionStatement $item
     * @return \StructType\GetStatementResult
     */
    public function addToStatements(\StructType\TransactionStatement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransactionStatement) {
            throw new \InvalidArgumentException(sprintf('The statements property can only contain items of \StructType\TransactionStatement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->statements[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetStatementResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
