<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenericParam StructType
 * @subpackage Structs
 * @Author CybernatiC
 * @Version 0.2
 * @Date 17.12.2017
 */
class GenericParam extends AbstractStructBase
{
    /**
     * The paramKey
     * @var string
     */
    public $paramKey;
    /**
     * The paramValue
     * @var string
     */
    public $paramValue;
    /**
     * Constructor method for GenericParam
     * @uses GenericParam::setParamKey()
     * @uses GenericParam::setParamValue()
     * @param string $paramKey
     * @param string $paramValue
     */
    public function __construct($paramKey = null, $paramValue = null)
    {
        $this
            ->setParamKey($paramKey)
            ->setParamValue($paramValue);
    }
    /**
     * Get paramKey value
     * @return string|null
     */
    public function getParamKey()
    {
        return $this->paramKey;
    }
    /**
     * Set paramKey value
     * @param string $paramKey
     * @return \StructType\GenericParam
     */
    public function setParamKey($paramKey = null)
    {
        // validation for constraint: string
        if (!is_null($paramKey) && !is_string($paramKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paramKey)), __LINE__);
        }
        $this->paramKey = $paramKey;
        return $this;
    }
    /**
     * Get paramValue value
     * @return string|null
     */
    public function getParamValue()
    {
        return $this->paramValue;
    }
    /**
     * Set paramValue value
     * @param string $paramValue
     * @return \StructType\GenericParam
     */
    public function setParamValue($paramValue = null)
    {
        // validation for constraint: string
        if (!is_null($paramValue) && !is_string($paramValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paramValue)), __LINE__);
        }
        $this->paramValue = $paramValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GenericParam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
