<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckTransactionResult StructType
 * Meta informations extracted from the WSDL
 * - type: tns:CheckTransactionResult
 * @subpackage Structs
 * @Author CybernatiC
 * @Version 0.2
 * @Date 17.12.2017
 */
class CheckTransactionResult extends GenericResult
{
    /**
     * The providerTrnId
     * @var int
     */
    public $providerTrnId;
    /**
     * The transactionState
     * @var int
     */
    public $transactionState;
    /**
     * The transactionStateErrorStatus
     * @var int
     */
    public $transactionStateErrorStatus;
    /**
     * The transactionStateErrorMsg
     * @var string
     */
    public $transactionStateErrorMsg;
    /**
     * Constructor method for CheckTransactionResult
     * @uses CheckTransactionResult::setProviderTrnId()
     * @uses CheckTransactionResult::setTransactionState()
     * @uses CheckTransactionResult::setTransactionStateErrorStatus()
     * @uses CheckTransactionResult::setTransactionStateErrorMsg()
     * @param int $providerTrnId
     * @param int $transactionState
     * @param int $transactionStateErrorStatus
     * @param string $transactionStateErrorMsg
     */
    public function __construct($providerTrnId = null, $transactionState = null, $transactionStateErrorStatus = null, $transactionStateErrorMsg = null)
    {
        $this
            ->setProviderTrnId($providerTrnId)
            ->setTransactionState($transactionState)
            ->setTransactionStateErrorStatus($transactionStateErrorStatus)
            ->setTransactionStateErrorMsg($transactionStateErrorMsg);
    }
    /**
     * Get providerTrnId value
     * @return int|null
     */
    public function getProviderTrnId()
    {
        return $this->providerTrnId;
    }
    /**
     * Set providerTrnId value
     * @param int $providerTrnId
     * @return \StructType\CheckTransactionResult
     */
    public function setProviderTrnId($providerTrnId = null)
    {
        // validation for constraint: int
        if (!is_null($providerTrnId) && !is_numeric($providerTrnId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($providerTrnId)), __LINE__);
        }
        $this->providerTrnId = $providerTrnId;
        return $this;
    }
    /**
     * Get transactionState value
     * @return int|null
     */
    public function getTransactionState()
    {
        return $this->transactionState;
    }
    /**
     * Set transactionState value
     * @param int $transactionState
     * @return \StructType\CheckTransactionResult
     */
    public function setTransactionState($transactionState = null)
    {
        // validation for constraint: int
        if (!is_null($transactionState) && !is_numeric($transactionState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactionState)), __LINE__);
        }
        $this->transactionState = $transactionState;
        return $this;
    }
    /**
     * Get transactionStateErrorStatus value
     * @return int|null
     */
    public function getTransactionStateErrorStatus()
    {
        return $this->transactionStateErrorStatus;
    }
    /**
     * Set transactionStateErrorStatus value
     * @param int $transactionStateErrorStatus
     * @return \StructType\CheckTransactionResult
     */
    public function setTransactionStateErrorStatus($transactionStateErrorStatus = null)
    {
        // validation for constraint: int
        if (!is_null($transactionStateErrorStatus) && !is_numeric($transactionStateErrorStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactionStateErrorStatus)), __LINE__);
        }
        $this->transactionStateErrorStatus = $transactionStateErrorStatus;
        return $this;
    }
    /**
     * Get transactionStateErrorMsg value
     * @return string|null
     */
    public function getTransactionStateErrorMsg()
    {
        return $this->transactionStateErrorMsg;
    }
    /**
     * Set transactionStateErrorMsg value
     * @param string $transactionStateErrorMsg
     * @return \StructType\CheckTransactionResult
     */
    public function setTransactionStateErrorMsg($transactionStateErrorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStateErrorMsg) && !is_string($transactionStateErrorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStateErrorMsg)), __LINE__);
        }
        $this->transactionStateErrorMsg = $transactionStateErrorMsg;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckTransactionResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
