<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Change ServiceType
 * @subpackage Services
 * @Author CybernatiC
 * @Version 0.2
 * @Date 17.12.2017
 */
class Change extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ChangePassword
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChangePasswordArguments $arguments
     * @return \StructType\ChangePasswordResult|bool
     */
    public function ChangePassword(\StructType\ChangePasswordArguments $arguments)
    {
        try {
            $this->setResult(self::getSoapClient()->ChangePassword($arguments));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ChangePasswordResult
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
