<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 * @Author CybernatiC
 * @Version 0.2
 * @Date 17.12.2017
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelTransaction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelTransactionArguments $arguments
     * @return \StructType\CancelTransactionResult|bool
     */
    public function CancelTransaction(\StructType\CancelTransactionArguments $arguments)
    {
        try {
            $this->setResult(self::getSoapClient()->CancelTransaction($arguments));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CancelTransactionResult
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
