<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelTransactionArguments StructType
 * Meta informations extracted from the WSDL
 * - type: tns:CancelTransactionArguments
 * @subpackage Structs
 */
class CancelTransactionArguments extends GenericArguments
{
    /**
     * The serviceId
     * @var int
     */
    public $serviceId;
    /**
     * The transactionId
     * @var int
     */
    public $transactionId;
    /**
     * The transactionTime
     * @var string
     */
    public $transactionTime;
    /**
     * The parameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GenericParam[]
     */
    public $parameters;
    /**
     * Constructor method for CancelTransactionArguments
     * @uses CancelTransactionArguments::setServiceId()
     * @uses CancelTransactionArguments::setTransactionId()
     * @uses CancelTransactionArguments::setTransactionTime()
     * @uses CancelTransactionArguments::setParameters()
     * @param int $serviceId
     * @param int $transactionId
     * @param string $transactionTime
     * @param \StructType\GenericParam[] $parameters
     */
    public function __construct($serviceId = null, $transactionId = null, $transactionTime = null, array $parameters = array())
    {
        $this
            ->setServiceId($serviceId)
            ->setTransactionId($transactionId)
            ->setTransactionTime($transactionTime)
            ->setParameters($parameters);
    }
    /**
     * Get serviceId value
     * @return int|null
     */
    public function getServiceId()
    {
        return $this->serviceId;
    }
    /**
     * Set serviceId value
     * @param int $serviceId
     * @return \StructType\CancelTransactionArguments
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: int
        if (!is_null($serviceId) && !is_numeric($serviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceId)), __LINE__);
        }
        $this->serviceId = $serviceId;
        return $this;
    }
    /**
     * Get transactionId value
     * @return int|null
     */
    public function getTransactionId()
    {
        return $this->transactionId;
    }
    /**
     * Set transactionId value
     * @param int $transactionId
     * @return \StructType\CancelTransactionArguments
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionId) && !is_numeric($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactionId)), __LINE__);
        }
        $this->transactionId = $transactionId;
        return $this;
    }
    /**
     * Get transactionTime value
     * @return string|null
     */
    public function getTransactionTime()
    {
        return $this->transactionTime;
    }
    /**
     * Set transactionTime value
     * @param string $transactionTime
     * @return \StructType\CancelTransactionArguments
     */
    public function setTransactionTime($transactionTime = null)
    {
        // validation for constraint: string
        if (!is_null($transactionTime) && !is_string($transactionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionTime)), __LINE__);
        }
        $this->transactionTime = $transactionTime;
        return $this;
    }
    /**
     * Get parameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GenericParam[]|null
     */
    public function getParameters()
    {
        return isset($this->parameters) ? $this->parameters : null;
    }
    /**
     * Set parameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GenericParam[] $parameters
     * @return \StructType\CancelTransactionArguments
     */
    public function setParameters(array $parameters = array())
    {
        foreach ($parameters as $cancelTransactionArgumentsParametersItem) {
            // validation for constraint: itemType
            if (!$cancelTransactionArgumentsParametersItem instanceof \StructType\GenericParam) {
                throw new \InvalidArgumentException(sprintf('The parameters property can only contain items of \StructType\GenericParam, "%s" given', is_object($cancelTransactionArgumentsParametersItem) ? get_class($cancelTransactionArgumentsParametersItem) : gettype($cancelTransactionArgumentsParametersItem)), __LINE__);
            }
        }
        if (is_null($parameters) || (is_array($parameters) && empty($parameters))) {
            unset($this->parameters);
        } else {
            $this->parameters = $parameters;
        }
        return $this;
    }
    /**
     * Add item to parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericParam $item
     * @return \StructType\CancelTransactionArguments
     */
    public function addToParameters(\StructType\GenericParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GenericParam) {
            throw new \InvalidArgumentException(sprintf('The parameters property can only contain items of \StructType\GenericParam, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->parameters[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelTransactionArguments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
