<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PerformTransactionResult StructType
 * Meta informations extracted from the WSDL
 * - type: tns:PerformTransactionResult
 * @subpackage Structs
 */
class PerformTransactionResult extends GenericResult
{
    /**
     * The parameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GenericParam[]
     */
    public $parameters;
    /**
     * The providerTrnId
     * @var int
     */
    public $providerTrnId;
    /**
     * Constructor method for PerformTransactionResult
     * @uses PerformTransactionResult::setParameters()
     * @uses PerformTransactionResult::setProviderTrnId()
     * @param \StructType\GenericParam[] $parameters
     * @param int $providerTrnId
     */
    public function __construct(array $parameters = array(), $providerTrnId = null)
    {
        $this
            ->setParameters($parameters)
            ->setProviderTrnId($providerTrnId);
    }
    /**
     * Get parameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GenericParam[]|null
     */
    public function getParameters()
    {
        return isset($this->parameters) ? $this->parameters : null;
    }
    /**
     * Set parameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GenericParam[] $parameters
     * @return \StructType\PerformTransactionResult
     */
    public function setParameters(array $parameters = array())
    {
        foreach ($parameters as $performTransactionResultParametersItem) {
            // validation for constraint: itemType
            if (!$performTransactionResultParametersItem instanceof \StructType\GenericParam) {
                throw new \InvalidArgumentException(sprintf('The parameters property can only contain items of \StructType\GenericParam, "%s" given', is_object($performTransactionResultParametersItem) ? get_class($performTransactionResultParametersItem) : gettype($performTransactionResultParametersItem)), __LINE__);
            }
        }
        if (is_null($parameters) || (is_array($parameters) && empty($parameters))) {
            unset($this->parameters);
        } else {
            $this->parameters = $parameters;
        }
        return $this;
    }
    /**
     * Add item to parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericParam $item
     * @return \StructType\PerformTransactionResult
     */
    public function addToParameters(\StructType\GenericParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GenericParam) {
            throw new \InvalidArgumentException(sprintf('The parameters property can only contain items of \StructType\GenericParam, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->parameters[] = $item;
        return $this;
    }
    /**
     * Get providerTrnId value
     * @return int|null
     */
    public function getProviderTrnId()
    {
        return $this->providerTrnId;
    }
    /**
     * Set providerTrnId value
     * @param int $providerTrnId
     * @return \StructType\PerformTransactionResult
     */
    public function setProviderTrnId($providerTrnId = null)
    {
        // validation for constraint: int
        if (!is_null($providerTrnId) && !is_numeric($providerTrnId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($providerTrnId)), __LINE__);
        }
        $this->providerTrnId = $providerTrnId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PerformTransactionResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
