<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenericResult StructType
 * @subpackage Structs
 */
class GenericResult extends AbstractStructBase
{
    /**
     * The errorMsg
     * @var string
     */
    public $errorMsg;
    /**
     * The status
     * @var int
     */
    public $status;
    /**
     * The timeStamp
     * @var string
     */
    public $timeStamp;
    /**
     * Constructor method for GenericResult
     * @uses GenericResult::setErrorMsg()
     * @uses GenericResult::setStatus()
     * @uses GenericResult::setTimeStamp()
     * @param string $errorMsg
     * @param int $status
     * @param string $timeStamp
     */
    public function __construct($errorMsg = null, $status = null, $timeStamp = null)
    {
        $this
            ->setErrorMsg($errorMsg)
            ->setStatus($status)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get errorMsg value
     * @return string|null
     */
    public function getErrorMsg()
    {
        return $this->errorMsg;
    }
    /**
     * Set errorMsg value
     * @param string $errorMsg
     * @return \StructType\GenericResult
     */
    public function setErrorMsg($errorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($errorMsg) && !is_string($errorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMsg)), __LINE__);
        }
        $this->errorMsg = $errorMsg;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\GenericResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !is_numeric($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get timeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->timeStamp;
    }
    /**
     * Set timeStamp value
     * @param string $timeStamp
     * @return \StructType\GenericResult
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->timeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GenericResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
