<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionStatement StructType
 * @subpackage Structs
 */
class TransactionStatement extends AbstractStructBase
{
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $amount;
    /**
     * The providerTrnId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $providerTrnId;
    /**
     * The transactionId
     * @var int
     */
    public $transactionId;
    /**
     * The transactionTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transactionTime;
    /**
     * Constructor method for TransactionStatement
     * @uses TransactionStatement::setAmount()
     * @uses TransactionStatement::setProviderTrnId()
     * @uses TransactionStatement::setTransactionId()
     * @uses TransactionStatement::setTransactionTime()
     * @param int $amount
     * @param int $providerTrnId
     * @param int $transactionId
     * @param string $transactionTime
     */
    public function __construct($amount = null, $providerTrnId = null, $transactionId = null, $transactionTime = null)
    {
        $this
            ->setAmount($amount)
            ->setProviderTrnId($providerTrnId)
            ->setTransactionId($transactionId)
            ->setTransactionTime($transactionTime);
    }
    /**
     * Get amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\TransactionStatement
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !is_numeric($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get providerTrnId value
     * @return int|null
     */
    public function getProviderTrnId()
    {
        return $this->providerTrnId;
    }
    /**
     * Set providerTrnId value
     * @param int $providerTrnId
     * @return \StructType\TransactionStatement
     */
    public function setProviderTrnId($providerTrnId = null)
    {
        // validation for constraint: int
        if (!is_null($providerTrnId) && !is_numeric($providerTrnId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($providerTrnId)), __LINE__);
        }
        $this->providerTrnId = $providerTrnId;
        return $this;
    }
    /**
     * Get transactionId value
     * @return int|null
     */
    public function getTransactionId()
    {
        return $this->transactionId;
    }
    /**
     * Set transactionId value
     * @param int $transactionId
     * @return \StructType\TransactionStatement
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionId) && !is_numeric($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactionId)), __LINE__);
        }
        $this->transactionId = $transactionId;
        return $this;
    }
    /**
     * Get transactionTime value
     * @return string|null
     */
    public function getTransactionTime()
    {
        return $this->transactionTime;
    }
    /**
     * Set transactionTime value
     * @param string $transactionTime
     * @return \StructType\TransactionStatement
     */
    public function setTransactionTime($transactionTime = null)
    {
        // validation for constraint: string
        if (!is_null($transactionTime) && !is_string($transactionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionTime)), __LINE__);
        }
        $this->transactionTime = $transactionTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransactionStatement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
