<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PerformTransactionArguments StructType
 * Meta informations extracted from the WSDL
 * - type: tns:PerformTransactionArguments
 * @subpackage Structs
 */
class PerformTransactionArguments extends GenericArguments
{
    /**
     * The amount
     * @var int
     */
    public $amount;
    /**
     * The parameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GenericParam[]
     */
    public $parameters;
    /**
     * The serviceId
     * @var int
     */
    public $serviceId;
    /**
     * The transactionId
     * @var int
     */
    public $transactionId;
    /**
     * The transactionTime
     * @var string
     */
    public $transactionTime;
    /**
     * Constructor method for PerformTransactionArguments
     * @uses PerformTransactionArguments::setAmount()
     * @uses PerformTransactionArguments::setParameters()
     * @uses PerformTransactionArguments::setServiceId()
     * @uses PerformTransactionArguments::setTransactionId()
     * @uses PerformTransactionArguments::setTransactionTime()
     * @param int $amount
     * @param \StructType\GenericParam[] $parameters
     * @param int $serviceId
     * @param int $transactionId
     * @param string $transactionTime
     */
    public function __construct($amount = null, array $parameters = array(), $serviceId = null, $transactionId = null, $transactionTime = null)
    {
        $this
            ->setAmount($amount)
            ->setParameters($parameters)
            ->setServiceId($serviceId)
            ->setTransactionId($transactionId)
            ->setTransactionTime($transactionTime);
    }
    /**
     * Get amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\PerformTransactionArguments
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !is_numeric($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get parameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GenericParam[]|null
     */
    public function getParameters()
    {
        return isset($this->parameters) ? $this->parameters : null;
    }
    /**
     * Set parameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GenericParam[] $parameters
     * @return \StructType\PerformTransactionArguments
     */
    public function setParameters(array $parameters = array())
    {
        foreach ($parameters as $performTransactionArgumentsParametersItem) {
            // validation for constraint: itemType
            if (!$performTransactionArgumentsParametersItem instanceof \StructType\GenericParam) {
                throw new \InvalidArgumentException(sprintf('The parameters property can only contain items of \StructType\GenericParam, "%s" given', is_object($performTransactionArgumentsParametersItem) ? get_class($performTransactionArgumentsParametersItem) : gettype($performTransactionArgumentsParametersItem)), __LINE__);
            }
        }
        if (is_null($parameters) || (is_array($parameters) && empty($parameters))) {
            unset($this->parameters);
        } else {
            $this->parameters = $parameters;
        }
        return $this;
    }
    /**
     * Add item to parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericParam $item
     * @return \StructType\PerformTransactionArguments
     */
    public function addToParameters(\StructType\GenericParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GenericParam) {
            throw new \InvalidArgumentException(sprintf('The parameters property can only contain items of \StructType\GenericParam, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->parameters[] = $item;
        return $this;
    }
    /**
     * Get serviceId value
     * @return int|null
     */
    public function getServiceId()
    {
        return $this->serviceId;
    }
    /**
     * Set serviceId value
     * @param int $serviceId
     * @return \StructType\PerformTransactionArguments
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: int
        if (!is_null($serviceId) && !is_numeric($serviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceId)), __LINE__);
        }
        $this->serviceId = $serviceId;
        return $this;
    }
    /**
     * Get transactionId value
     * @return int|null
     */
    public function getTransactionId()
    {
        return $this->transactionId;
    }
    /**
     * Set transactionId value
     * @param int $transactionId
     * @return \StructType\PerformTransactionArguments
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionId) && !is_numeric($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactionId)), __LINE__);
        }
        $this->transactionId = $transactionId;
        return $this;
    }
    /**
     * Get transactionTime value
     * @return string|null
     */
    public function getTransactionTime()
    {
        return $this->transactionTime;
    }
    /**
     * Set transactionTime value
     * @param string $transactionTime
     * @return \StructType\PerformTransactionArguments
     */
    public function setTransactionTime($transactionTime = null)
    {
        // validation for constraint: string
        if (!is_null($transactionTime) && !is_string($transactionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionTime)), __LINE__);
        }
        $this->transactionTime = $transactionTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PerformTransactionArguments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
