<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInformationArguments StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetInformationArguments
 * @subpackage Structs
 */
class GetInformationArguments extends GenericArguments
{
    /**
     * The parameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GenericParam[]
     */
    public $parameters;
    /**
     * The serviceId
     * @var int
     */
    public $serviceId;
    /**
     * Constructor method for GetInformationArguments
     * @uses GetInformationArguments::setParameters()
     * @uses GetInformationArguments::setServiceId()
     * @param \StructType\GenericParam[] $parameters
     * @param int $serviceId
     */
    public function __construct(array $parameters = array(), $serviceId = null)
    {
        $this
            ->setParameters($parameters)
            ->setServiceId($serviceId);
    }
    /**
     * Get parameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GenericParam[]|null
     */
    public function getParameters()
    {
        return isset($this->parameters) ? $this->parameters : null;
    }
    /**
     * Set parameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GenericParam[] $parameters
     * @return \StructType\GetInformationArguments
     */
    public function setParameters(array $parameters = array())
    {
        foreach ($parameters as $getInformationArgumentsParametersItem) {
            // validation for constraint: itemType
            if (!$getInformationArgumentsParametersItem instanceof \StructType\GenericParam) {
                throw new \InvalidArgumentException(sprintf('The parameters property can only contain items of \StructType\GenericParam, "%s" given', is_object($getInformationArgumentsParametersItem) ? get_class($getInformationArgumentsParametersItem) : gettype($getInformationArgumentsParametersItem)), __LINE__);
            }
        }
        if (is_null($parameters) || (is_array($parameters) && empty($parameters))) {
            unset($this->parameters);
        } else {
            $this->parameters = $parameters;
        }
        return $this;
    }
    /**
     * Add item to parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericParam $item
     * @return \StructType\GetInformationArguments
     */
    public function addToParameters(\StructType\GenericParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GenericParam) {
            throw new \InvalidArgumentException(sprintf('The parameters property can only contain items of \StructType\GenericParam, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->parameters[] = $item;
        return $this;
    }
    /**
     * Get serviceId value
     * @return int|null
     */
    public function getServiceId()
    {
        return $this->serviceId;
    }
    /**
     * Set serviceId value
     * @param int $serviceId
     * @return \StructType\GetInformationArguments
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: int
        if (!is_null($serviceId) && !is_numeric($serviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceId)), __LINE__);
        }
        $this->serviceId = $serviceId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetInformationArguments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
