<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://oxmail.khalil.pw/webservices/OXContextService?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://oxmail.khalil.pw/webservices/OXContextService?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \OXModule\ClassMap::get(),
);
/**
 * Samples for Change ServiceType
 */
$change = new \OXModule\ServiceClass\Change($options);
/**
 * Sample call for changeModuleAccessByName operation/method
 */
if ($change->changeModuleAccessByName(new \OXModule\StructClass\ChangeModuleAccessByName()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for changeModuleAccess operation/method
 */
if ($change->changeModuleAccess(new \OXModule\StructClass\ChangeModuleAccess()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for changeCapabilities operation/method
 */
if ($change->changeCapabilities(new \OXModule\StructClass\ChangeCapabilities()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for changeQuota operation/method
 */
if ($change->changeQuota(new \OXModule\StructClass\ChangeQuota()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for change operation/method
 */
if ($change->change(new \OXModule\StructClass\Change()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \OXModule\ServiceClass\Get($options);
/**
 * Sample call for getData operation/method
 */
if ($get->getData(new \OXModule\StructClass\GetData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAdminId operation/method
 */
if ($get->getAdminId(new \OXModule\StructClass\GetAdminId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getContextCapabilities operation/method
 */
if ($get->getContextCapabilities(new \OXModule\StructClass\GetContextCapabilities()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAccessCombinationName operation/method
 */
if ($get->getAccessCombinationName(new \OXModule\StructClass\GetAccessCombinationName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getModuleAccess operation/method
 */
if ($get->getModuleAccess(new \OXModule\StructClass\GetModuleAccess()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Disable ServiceType
 */
$disable = new \OXModule\ServiceClass\Disable($options);
/**
 * Sample call for disableAll operation/method
 */
if ($disable->disableAll(new \OXModule\StructClass\DisableAll()) !== false) {
    print_r($disable->getResult());
} else {
    print_r($disable->getLastError());
}
/**
 * Sample call for disable operation/method
 */
if ($disable->disable(new \OXModule\StructClass\Disable()) !== false) {
    print_r($disable->getResult());
} else {
    print_r($disable->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \OXModule\ServiceClass\Create($options);
/**
 * Sample call for create operation/method
 */
if ($create->create(new \OXModule\StructClass\Create()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createModuleAccessByName operation/method
 */
if ($create->createModuleAccessByName(new \OXModule\StructClass\CreateModuleAccessByName()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createModuleAccess operation/method
 */
if ($create->createModuleAccess(new \OXModule\StructClass\CreateModuleAccess()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Enable ServiceType
 */
$enable = new \OXModule\ServiceClass\Enable($options);
/**
 * Sample call for enable operation/method
 */
if ($enable->enable(new \OXModule\StructClass\Enable()) !== false) {
    print_r($enable->getResult());
} else {
    print_r($enable->getLastError());
}
/**
 * Sample call for enableAll operation/method
 */
if ($enable->enableAll(new \OXModule\StructClass\EnableAll()) !== false) {
    print_r($enable->getResult());
} else {
    print_r($enable->getLastError());
}
/**
 * Samples for Downgrade ServiceType
 */
$downgrade = new \OXModule\ServiceClass\Downgrade($options);
/**
 * Sample call for downgrade operation/method
 */
if ($downgrade->downgrade(new \OXModule\StructClass\Downgrade()) !== false) {
    print_r($downgrade->getResult());
} else {
    print_r($downgrade->getLastError());
}
/**
 * Samples for Move ServiceType
 */
$move = new \OXModule\ServiceClass\Move($options);
/**
 * Sample call for moveContextDatabase operation/method
 */
if ($move->moveContextDatabase(new \OXModule\StructClass\MoveContextDatabase()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for moveContextFilestore operation/method
 */
if ($move->moveContextFilestore(new \OXModule\StructClass\MoveContextFilestore()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \OXModule\ServiceClass\Delete($options);
/**
 * Sample call for delete operation/method
 */
if ($delete->delete(new \OXModule\StructClass\Delete()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \OXModule\ServiceClass\_List($options);
/**
 * Sample call for listQuota operation/method
 */
if ($list->listQuota(new \OXModule\StructClass\ListQuota()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listAll operation/method
 */
if ($list->listAll(new \OXModule\StructClass\ListAll()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listByDatabase operation/method
 */
if ($list->listByDatabase(new \OXModule\StructClass\ListByDatabase()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listByFilestore operation/method
 */
if ($list->listByFilestore(new \OXModule\StructClass\ListByFilestore()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for _list_2 operation/method
 */
if ($list->_list_2(new \OXModule\StructClass\_list()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Exists ServiceType
 */
$exists = new \OXModule\ServiceClass\Exists($options);
/**
 * Sample call for exists operation/method
 */
if ($exists->exists(new \OXModule\StructClass\Exists()) !== false) {
    print_r($exists->getResult());
} else {
    print_r($exists->getLastError());
}
