<?php

namespace OXModule\StructClass;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SchemaSelectStrategy StructClass
 * @subpackage Structs
 */
class SchemaSelectStrategy extends AbstractStructBase
{
    /**
     * The schema_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $schema_name;
    /**
     * The strategy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $strategy;
    /**
     * Constructor method for SchemaSelectStrategy
     * @uses SchemaSelectStrategy::setSchema_name()
     * @uses SchemaSelectStrategy::setStrategy()
     * @param string $schema_name
     * @param string $strategy
     */
    public function __construct($schema_name = null, $strategy = null)
    {
        $this
            ->setSchema_name($schema_name)
            ->setStrategy($strategy);
    }
    /**
     * Get schema_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchema_name()
    {
        return isset($this->schema_name) ? $this->schema_name : null;
    }
    /**
     * Set schema_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schema_name
     * @return \OXModule\StructClass\SchemaSelectStrategy
     */
    public function setSchema_name($schema_name = null)
    {
        // validation for constraint: string
        if (!is_null($schema_name) && !is_string($schema_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schema_name)), __LINE__);
        }
        if (is_null($schema_name) || (is_array($schema_name) && empty($schema_name))) {
            unset($this->schema_name);
        } else {
            $this->schema_name = $schema_name;
        }
        return $this;
    }
    /**
     * Get strategy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStrategy()
    {
        return isset($this->strategy) ? $this->strategy : null;
    }
    /**
     * Set strategy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $strategy
     * @return \OXModule\StructClass\SchemaSelectStrategy
     */
    public function setStrategy($strategy = null)
    {
        // validation for constraint: string
        if (!is_null($strategy) && !is_string($strategy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($strategy)), __LINE__);
        }
        if (is_null($strategy) || (is_array($strategy) && empty($strategy))) {
            unset($this->strategy);
        } else {
            $this->strategy = $strategy;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \OXModule\StructClass\SchemaSelectStrategy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
