<?php

namespace OXModule\ServiceClass;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Exists ServiceClass
 * @subpackage Services
 */
class Exists extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named exists
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \OXModule\StructClass\Exists $parameters
     * @return \OXModule\StructClass\ExistsResponse|bool
     */
    public function exists(\OXModule\StructClass\Exists $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->exists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \OXModule\StructClass\ExistsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
