<?php

namespace OXModule\StructClass;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for listByDatabase StructClass
 * @subpackage Structs
 */
class ListByDatabase extends AbstractStructBase
{
    /**
     * The db
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \OXModule\StructClass\Database
     */
    public $db;
    /**
     * The auth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \OXModule\StructClass\Credentials
     */
    public $auth;
    /**
     * Constructor method for listByDatabase
     * @uses ListByDatabase::setDb()
     * @uses ListByDatabase::setAuth()
     * @param \OXModule\StructClass\Database $db
     * @param \OXModule\StructClass\Credentials $auth
     */
    public function __construct(\OXModule\StructClass\Database $db = null, \OXModule\StructClass\Credentials $auth = null)
    {
        $this
            ->setDb($db)
            ->setAuth($auth);
    }
    /**
     * Get db value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \OXModule\StructClass\Database|null
     */
    public function getDb()
    {
        return isset($this->db) ? $this->db : null;
    }
    /**
     * Set db value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \OXModule\StructClass\Database $db
     * @return \OXModule\StructClass\ListByDatabase
     */
    public function setDb(\OXModule\StructClass\Database $db = null)
    {
        if (is_null($db) || (is_array($db) && empty($db))) {
            unset($this->db);
        } else {
            $this->db = $db;
        }
        return $this;
    }
    /**
     * Get auth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \OXModule\StructClass\Credentials|null
     */
    public function getAuth()
    {
        return isset($this->auth) ? $this->auth : null;
    }
    /**
     * Set auth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \OXModule\StructClass\Credentials $auth
     * @return \OXModule\StructClass\ListByDatabase
     */
    public function setAuth(\OXModule\StructClass\Credentials $auth = null)
    {
        if (is_null($auth) || (is_array($auth) && empty($auth))) {
            unset($this->auth);
        } else {
            $this->auth = $auth;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \OXModule\StructClass\ListByDatabase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
