<?php

namespace OXModule\ServiceClass;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceClass
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \OXModule\StructClass\GetData $parameters
     * @return \OXModule\StructClass\GetDataResponse|bool
     */
    public function getData(\OXModule\StructClass\GetData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAdminId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \OXModule\StructClass\GetAdminId $parameters
     * @return \OXModule\StructClass\GetAdminIdResponse|bool
     */
    public function getAdminId(\OXModule\StructClass\GetAdminId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getAdminId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getContextCapabilities
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \OXModule\StructClass\GetContextCapabilities $parameters
     * @return \OXModule\StructClass\GetContextCapabilitiesResponse|bool
     */
    public function getContextCapabilities(\OXModule\StructClass\GetContextCapabilities $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getContextCapabilities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAccessCombinationName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \OXModule\StructClass\GetAccessCombinationName $parameters
     * @return \OXModule\StructClass\GetAccessCombinationNameResponse|bool
     */
    public function getAccessCombinationName(\OXModule\StructClass\GetAccessCombinationName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getAccessCombinationName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getModuleAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \OXModule\StructClass\GetModuleAccess $parameters
     * @return \OXModule\StructClass\GetModuleAccessResponse|bool
     */
    public function getModuleAccess(\OXModule\StructClass\GetModuleAccess $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getModuleAccess($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \OXModule\StructClass\GetAccessCombinationNameResponse|\OXModule\StructClass\GetAdminIdResponse|\OXModule\StructClass\GetContextCapabilitiesResponse|\OXModule\StructClass\GetDataResponse|\OXModule\StructClass\GetModuleAccessResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
