<?php

namespace OXModule\ServiceClass;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Enable ServiceClass
 * @subpackage Services
 */
class Enable extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named enable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \OXModule\StructClass\Enable $parameters
     * @return void|bool
     */
    public function enable(\OXModule\StructClass\Enable $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->enable($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named enableAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \OXModule\StructClass\EnableAll $parameters
     * @return void|bool
     */
    public function enableAll(\OXModule\StructClass\EnableAll $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->enableAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
