<?php

namespace OXModule\ServiceClass;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceClass
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named create
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \OXModule\StructClass\Create $parameters
     * @return \OXModule\StructClass\CreateResponse|bool
     */
    public function create(\OXModule\StructClass\Create $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->create($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createModuleAccessByName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \OXModule\StructClass\CreateModuleAccessByName $parameters
     * @return \OXModule\StructClass\CreateModuleAccessByNameResponse|bool
     */
    public function createModuleAccessByName(\OXModule\StructClass\CreateModuleAccessByName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->createModuleAccessByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createModuleAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \OXModule\StructClass\CreateModuleAccess $parameters
     * @return \OXModule\StructClass\CreateModuleAccessResponse|bool
     */
    public function createModuleAccess(\OXModule\StructClass\CreateModuleAccess $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->createModuleAccess($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \OXModule\StructClass\CreateModuleAccessByNameResponse|\OXModule\StructClass\CreateModuleAccessResponse|\OXModule\StructClass\CreateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
