<?php

namespace OXModule\StructClass;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Group StructClass
 * @subpackage Structs
 */
class Group extends AbstractStructBase
{
    /**
     * The displayname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $displayname;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $members;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * Constructor method for Group
     * @uses Group::setDisplayname()
     * @uses Group::setId()
     * @uses Group::setMembers()
     * @uses Group::setName()
     * @param string $displayname
     * @param int $id
     * @param int[] $members
     * @param string $name
     */
    public function __construct($displayname = null, $id = null, array $members = array(), $name = null)
    {
        $this
            ->setDisplayname($displayname)
            ->setId($id)
            ->setMembers($members)
            ->setName($name);
    }
    /**
     * Get displayname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayname()
    {
        return isset($this->displayname) ? $this->displayname : null;
    }
    /**
     * Set displayname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayname
     * @return \OXModule\StructClass\Group
     */
    public function setDisplayname($displayname = null)
    {
        // validation for constraint: string
        if (!is_null($displayname) && !is_string($displayname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayname)), __LINE__);
        }
        if (is_null($displayname) || (is_array($displayname) && empty($displayname))) {
            unset($this->displayname);
        } else {
            $this->displayname = $displayname;
        }
        return $this;
    }
    /**
     * Get id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : null;
    }
    /**
     * Set id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \OXModule\StructClass\Group
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->id);
        } else {
            $this->id = $id;
        }
        return $this;
    }
    /**
     * Get members value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getMembers()
    {
        return isset($this->members) ? $this->members : null;
    }
    /**
     * Set members value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $members
     * @return \OXModule\StructClass\Group
     */
    public function setMembers(array $members = array())
    {
        foreach ($members as $groupMembersItem) {
            // validation for constraint: itemType
            if (!is_numeric($groupMembersItem)) {
                throw new \InvalidArgumentException(sprintf('The members property can only contain items of int, "%s" given', is_object($groupMembersItem) ? get_class($groupMembersItem) : gettype($groupMembersItem)), __LINE__);
            }
        }
        if (is_null($members) || (is_array($members) && empty($members))) {
            unset($this->members);
        } else {
            $this->members = $members;
        }
        return $this;
    }
    /**
     * Add item to members value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \OXModule\StructClass\Group
     */
    public function addToMembers($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The members property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->members[] = $item;
        return $this;
    }
    /**
     * Get name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \OXModule\StructClass\Group
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \OXModule\StructClass\Group
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
