<?php

namespace OXModule\ServiceClass;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Move ServiceClass
 * @subpackage Services
 */
class Move extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named moveContextDatabase
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \OXModule\StructClass\MoveContextDatabase $parameters
     * @return \OXModule\StructClass\MoveContextDatabaseResponse|bool
     */
    public function moveContextDatabase(\OXModule\StructClass\MoveContextDatabase $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->moveContextDatabase($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named moveContextFilestore
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \OXModule\StructClass\MoveContextFilestore $parameters
     * @return \OXModule\StructClass\MoveContextFilestoreResponse|bool
     */
    public function moveContextFilestore(\OXModule\StructClass\MoveContextFilestore $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->moveContextFilestore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \OXModule\StructClass\MoveContextDatabaseResponse|\OXModule\StructClass\MoveContextFilestoreResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
