<?php

namespace OXModule\StructClass;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Quota StructClass
 * @subpackage Structs
 */
class Quota extends AbstractStructBase
{
    /**
     * The module
     * Meta informations extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $module;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - form: qualified
     * - nillable: true
     * @var int
     */
    public $limit;
    /**
     * Constructor method for Quota
     * @uses Quota::setModule()
     * @uses Quota::setLimit()
     * @param string $module
     * @param int $limit
     */
    public function __construct($module = null, $limit = null)
    {
        $this
            ->setModule($module)
            ->setLimit($limit);
    }
    /**
     * Get module value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModule()
    {
        return isset($this->module) ? $this->module : null;
    }
    /**
     * Set module value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $module
     * @return \OXModule\StructClass\Quota
     */
    public function setModule($module = null)
    {
        // validation for constraint: string
        if (!is_null($module) && !is_string($module)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($module)), __LINE__);
        }
        if (is_null($module) || (is_array($module) && empty($module))) {
            unset($this->module);
        } else {
            $this->module = $module;
        }
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \OXModule\StructClass\Quota
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \OXModule\StructClass\Quota
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
