<?php

namespace OXModule;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'ContextExistsException' => '\\OXModule\\StructClass\\ContextExistsException',
            'DatabaseUpdateException' => '\\OXModule\\StructClass\\DatabaseUpdateException',
            'InvalidCredentialsException' => '\\OXModule\\StructClass\\InvalidCredentialsException',
            'InvalidDataException' => '\\OXModule\\StructClass\\InvalidDataException',
            'NoSuchContextException' => '\\OXModule\\StructClass\\NoSuchContextException',
            'NoSuchDatabaseException' => '\\OXModule\\StructClass\\NoSuchDatabaseException',
            'NoSuchFilestoreException' => '\\OXModule\\StructClass\\NoSuchFilestoreException',
            'NoSuchReasonException' => '\\OXModule\\StructClass\\NoSuchReasonException',
            'OXContextException' => '\\OXModule\\StructClass\\OXContextException',
            'RemoteException' => '\\OXModule\\StructClass\\RemoteException',
            'StorageException' => '\\OXModule\\StructClass\\StorageException',
            'change' => '\\OXModule\\StructClass\\Change',
            'changeCapabilities' => '\\OXModule\\StructClass\\ChangeCapabilities',
            'changeModuleAccess' => '\\OXModule\\StructClass\\ChangeModuleAccess',
            'changeModuleAccessByName' => '\\OXModule\\StructClass\\ChangeModuleAccessByName',
            'changeQuota' => '\\OXModule\\StructClass\\ChangeQuota',
            'create' => '\\OXModule\\StructClass\\Create',
            'createModuleAccess' => '\\OXModule\\StructClass\\CreateModuleAccess',
            'createModuleAccessByName' => '\\OXModule\\StructClass\\CreateModuleAccessByName',
            'createModuleAccessByNameResponse' => '\\OXModule\\StructClass\\CreateModuleAccessByNameResponse',
            'createModuleAccessResponse' => '\\OXModule\\StructClass\\CreateModuleAccessResponse',
            'createResponse' => '\\OXModule\\StructClass\\CreateResponse',
            'delete' => '\\OXModule\\StructClass\\Delete',
            'disable' => '\\OXModule\\StructClass\\Disable',
            'disableAll' => '\\OXModule\\StructClass\\DisableAll',
            'downgrade' => '\\OXModule\\StructClass\\Downgrade',
            'enable' => '\\OXModule\\StructClass\\Enable',
            'enableAll' => '\\OXModule\\StructClass\\EnableAll',
            'exists' => '\\OXModule\\StructClass\\Exists',
            'existsResponse' => '\\OXModule\\StructClass\\ExistsResponse',
            'getAccessCombinationName' => '\\OXModule\\StructClass\\GetAccessCombinationName',
            'getAccessCombinationNameResponse' => '\\OXModule\\StructClass\\GetAccessCombinationNameResponse',
            'getAdminId' => '\\OXModule\\StructClass\\GetAdminId',
            'getAdminIdResponse' => '\\OXModule\\StructClass\\GetAdminIdResponse',
            'getContextCapabilities' => '\\OXModule\\StructClass\\GetContextCapabilities',
            'getContextCapabilitiesResponse' => '\\OXModule\\StructClass\\GetContextCapabilitiesResponse',
            'getData' => '\\OXModule\\StructClass\\GetData',
            'getDataResponse' => '\\OXModule\\StructClass\\GetDataResponse',
            'getModuleAccess' => '\\OXModule\\StructClass\\GetModuleAccess',
            'getModuleAccessResponse' => '\\OXModule\\StructClass\\GetModuleAccessResponse',
            'list' => '\\OXModule\\StructClass\\_list',
            'listAll' => '\\OXModule\\StructClass\\ListAll',
            'listAllResponse' => '\\OXModule\\StructClass\\ListAllResponse',
            'listByDatabase' => '\\OXModule\\StructClass\\ListByDatabase',
            'listByDatabaseResponse' => '\\OXModule\\StructClass\\ListByDatabaseResponse',
            'listByFilestore' => '\\OXModule\\StructClass\\ListByFilestore',
            'listByFilestoreResponse' => '\\OXModule\\StructClass\\ListByFilestoreResponse',
            'listQuota' => '\\OXModule\\StructClass\\ListQuota',
            'listQuotaResponse' => '\\OXModule\\StructClass\\ListQuotaResponse',
            'listResponse' => '\\OXModule\\StructClass\\ListResponse',
            'moveContextDatabase' => '\\OXModule\\StructClass\\MoveContextDatabase',
            'moveContextDatabaseResponse' => '\\OXModule\\StructClass\\MoveContextDatabaseResponse',
            'moveContextFilestore' => '\\OXModule\\StructClass\\MoveContextFilestore',
            'moveContextFilestoreResponse' => '\\OXModule\\StructClass\\MoveContextFilestoreResponse',
            'Exception' => '\\OXModule\\StructClass\\Exception',
            'IOException' => '\\OXModule\\StructClass\\IOException',
            'Context' => '\\OXModule\\StructClass\\Context',
            'Database' => '\\OXModule\\StructClass\\Database',
            'SOAPStringMapMap' => '\\OXModule\\StructClass\\SOAPStringMapMap',
            'SOAPMapEntry' => '\\OXModule\\StructClass\\SOAPMapEntry',
            'SOAPStringMap' => '\\OXModule\\StructClass\\SOAPStringMap',
            'Entry' => '\\OXModule\\StructClass\\Entry',
            'User' => '\\OXModule\\StructClass\\User',
            'Group' => '\\OXModule\\StructClass\\Group',
            'SchemaSelectStrategy' => '\\OXModule\\StructClass\\SchemaSelectStrategy',
            'UserModuleAccess' => '\\OXModule\\StructClass\\UserModuleAccess',
            'Filestore' => '\\OXModule\\StructClass\\Filestore',
            'Credentials' => '\\OXModule\\StructClass\\Credentials',
            'Quota' => '\\OXModule\\StructClass\\Quota',
        );
    }
}
