<?php

namespace OXModule\ServiceClass;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List ServiceClass
 * @subpackage Services
 */
class _List extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named listQuota
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \OXModule\StructClass\ListQuota $parameters
     * @return \OXModule\StructClass\ListQuotaResponse|bool
     */
    public function listQuota(\OXModule\StructClass\ListQuota $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->listQuota($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \OXModule\StructClass\ListAll $parameters
     * @return \OXModule\StructClass\ListAllResponse|bool
     */
    public function listAll(\OXModule\StructClass\ListAll $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->listAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listByDatabase
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \OXModule\StructClass\ListByDatabase $parameters
     * @return \OXModule\StructClass\ListByDatabaseResponse|bool
     */
    public function listByDatabase(\OXModule\StructClass\ListByDatabase $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->listByDatabase($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listByFilestore
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \OXModule\StructClass\ListByFilestore $parameters
     * @return \OXModule\StructClass\ListByFilestoreResponse|bool
     */
    public function listByFilestore(\OXModule\StructClass\ListByFilestore $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->listByFilestore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named list
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \OXModule\StructClass\_list $parameters
     * @return \OXModule\StructClass\ListResponse|bool
     */
    public function _list(\OXModule\StructClass\_list $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->list($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \OXModule\StructClass\ListAllResponse|\OXModule\StructClass\ListByDatabaseResponse|\OXModule\StructClass\ListByFilestoreResponse|\OXModule\StructClass\ListQuotaResponse|\OXModule\StructClass\ListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
