<?php

namespace OXModule\StructClass;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Context StructClass
 * @subpackage Structs
 */
class Context extends AbstractStructBase
{
    /**
     * The average_size
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $average_size;
    /**
     * The enabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $enabled;
    /**
     * The filestoreId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $filestoreId;
    /**
     * The filestore_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $filestore_name;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The loginMappings
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $loginMappings;
    /**
     * The maxQuota
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $maxQuota;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The readDatabase
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \OXModule\StructClass\Database
     */
    public $readDatabase;
    /**
     * The usedQuota
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $usedQuota;
    /**
     * The userAttributes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \OXModule\StructClass\SOAPStringMapMap
     */
    public $userAttributes;
    /**
     * The writeDatabase
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \OXModule\StructClass\Database
     */
    public $writeDatabase;
    /**
     * Constructor method for Context
     * @uses Context::setAverage_size()
     * @uses Context::setEnabled()
     * @uses Context::setFilestoreId()
     * @uses Context::setFilestore_name()
     * @uses Context::setId()
     * @uses Context::setLoginMappings()
     * @uses Context::setMaxQuota()
     * @uses Context::setName()
     * @uses Context::setReadDatabase()
     * @uses Context::setUsedQuota()
     * @uses Context::setUserAttributes()
     * @uses Context::setWriteDatabase()
     * @param int $average_size
     * @param bool $enabled
     * @param int $filestoreId
     * @param string $filestore_name
     * @param int $id
     * @param string[] $loginMappings
     * @param int $maxQuota
     * @param string $name
     * @param \OXModule\StructClass\Database $readDatabase
     * @param int $usedQuota
     * @param \OXModule\StructClass\SOAPStringMapMap $userAttributes
     * @param \OXModule\StructClass\Database $writeDatabase
     */
    public function __construct($average_size = null, $enabled = null, $filestoreId = null, $filestore_name = null, $id = null, array $loginMappings = array(), $maxQuota = null, $name = null, \OXModule\StructClass\Database $readDatabase = null, $usedQuota = null, \OXModule\StructClass\SOAPStringMapMap $userAttributes = null, \OXModule\StructClass\Database $writeDatabase = null)
    {
        $this
            ->setAverage_size($average_size)
            ->setEnabled($enabled)
            ->setFilestoreId($filestoreId)
            ->setFilestore_name($filestore_name)
            ->setId($id)
            ->setLoginMappings($loginMappings)
            ->setMaxQuota($maxQuota)
            ->setName($name)
            ->setReadDatabase($readDatabase)
            ->setUsedQuota($usedQuota)
            ->setUserAttributes($userAttributes)
            ->setWriteDatabase($writeDatabase);
    }
    /**
     * Get average_size value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAverage_size()
    {
        return isset($this->average_size) ? $this->average_size : null;
    }
    /**
     * Set average_size value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $average_size
     * @return \OXModule\StructClass\Context
     */
    public function setAverage_size($average_size = null)
    {
        // validation for constraint: int
        if (!is_null($average_size) && !is_numeric($average_size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($average_size)), __LINE__);
        }
        if (is_null($average_size) || (is_array($average_size) && empty($average_size))) {
            unset($this->average_size);
        } else {
            $this->average_size = $average_size;
        }
        return $this;
    }
    /**
     * Get enabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEnabled()
    {
        return isset($this->enabled) ? $this->enabled : null;
    }
    /**
     * Set enabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $enabled
     * @return \OXModule\StructClass\Context
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enabled)), __LINE__);
        }
        if (is_null($enabled) || (is_array($enabled) && empty($enabled))) {
            unset($this->enabled);
        } else {
            $this->enabled = $enabled;
        }
        return $this;
    }
    /**
     * Get filestoreId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFilestoreId()
    {
        return isset($this->filestoreId) ? $this->filestoreId : null;
    }
    /**
     * Set filestoreId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $filestoreId
     * @return \OXModule\StructClass\Context
     */
    public function setFilestoreId($filestoreId = null)
    {
        // validation for constraint: int
        if (!is_null($filestoreId) && !is_numeric($filestoreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($filestoreId)), __LINE__);
        }
        if (is_null($filestoreId) || (is_array($filestoreId) && empty($filestoreId))) {
            unset($this->filestoreId);
        } else {
            $this->filestoreId = $filestoreId;
        }
        return $this;
    }
    /**
     * Get filestore_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilestore_name()
    {
        return isset($this->filestore_name) ? $this->filestore_name : null;
    }
    /**
     * Set filestore_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filestore_name
     * @return \OXModule\StructClass\Context
     */
    public function setFilestore_name($filestore_name = null)
    {
        // validation for constraint: string
        if (!is_null($filestore_name) && !is_string($filestore_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filestore_name)), __LINE__);
        }
        if (is_null($filestore_name) || (is_array($filestore_name) && empty($filestore_name))) {
            unset($this->filestore_name);
        } else {
            $this->filestore_name = $filestore_name;
        }
        return $this;
    }
    /**
     * Get id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : null;
    }
    /**
     * Set id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \OXModule\StructClass\Context
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->id);
        } else {
            $this->id = $id;
        }
        return $this;
    }
    /**
     * Get loginMappings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getLoginMappings()
    {
        return isset($this->loginMappings) ? $this->loginMappings : null;
    }
    /**
     * Set loginMappings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $loginMappings
     * @return \OXModule\StructClass\Context
     */
    public function setLoginMappings(array $loginMappings = array())
    {
        foreach ($loginMappings as $contextLoginMappingsItem) {
            // validation for constraint: itemType
            if (!is_string($contextLoginMappingsItem)) {
                throw new \InvalidArgumentException(sprintf('The loginMappings property can only contain items of string, "%s" given', is_object($contextLoginMappingsItem) ? get_class($contextLoginMappingsItem) : gettype($contextLoginMappingsItem)), __LINE__);
            }
        }
        if (is_null($loginMappings) || (is_array($loginMappings) && empty($loginMappings))) {
            unset($this->loginMappings);
        } else {
            $this->loginMappings = $loginMappings;
        }
        return $this;
    }
    /**
     * Add item to loginMappings value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \OXModule\StructClass\Context
     */
    public function addToLoginMappings($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The loginMappings property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->loginMappings[] = $item;
        return $this;
    }
    /**
     * Get maxQuota value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxQuota()
    {
        return isset($this->maxQuota) ? $this->maxQuota : null;
    }
    /**
     * Set maxQuota value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxQuota
     * @return \OXModule\StructClass\Context
     */
    public function setMaxQuota($maxQuota = null)
    {
        // validation for constraint: int
        if (!is_null($maxQuota) && !is_numeric($maxQuota)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxQuota)), __LINE__);
        }
        if (is_null($maxQuota) || (is_array($maxQuota) && empty($maxQuota))) {
            unset($this->maxQuota);
        } else {
            $this->maxQuota = $maxQuota;
        }
        return $this;
    }
    /**
     * Get name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \OXModule\StructClass\Context
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get readDatabase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \OXModule\StructClass\Database|null
     */
    public function getReadDatabase()
    {
        return isset($this->readDatabase) ? $this->readDatabase : null;
    }
    /**
     * Set readDatabase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \OXModule\StructClass\Database $readDatabase
     * @return \OXModule\StructClass\Context
     */
    public function setReadDatabase(\OXModule\StructClass\Database $readDatabase = null)
    {
        if (is_null($readDatabase) || (is_array($readDatabase) && empty($readDatabase))) {
            unset($this->readDatabase);
        } else {
            $this->readDatabase = $readDatabase;
        }
        return $this;
    }
    /**
     * Get usedQuota value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUsedQuota()
    {
        return isset($this->usedQuota) ? $this->usedQuota : null;
    }
    /**
     * Set usedQuota value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $usedQuota
     * @return \OXModule\StructClass\Context
     */
    public function setUsedQuota($usedQuota = null)
    {
        // validation for constraint: int
        if (!is_null($usedQuota) && !is_numeric($usedQuota)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($usedQuota)), __LINE__);
        }
        if (is_null($usedQuota) || (is_array($usedQuota) && empty($usedQuota))) {
            unset($this->usedQuota);
        } else {
            $this->usedQuota = $usedQuota;
        }
        return $this;
    }
    /**
     * Get userAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \OXModule\StructClass\SOAPStringMapMap|null
     */
    public function getUserAttributes()
    {
        return isset($this->userAttributes) ? $this->userAttributes : null;
    }
    /**
     * Set userAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \OXModule\StructClass\SOAPStringMapMap $userAttributes
     * @return \OXModule\StructClass\Context
     */
    public function setUserAttributes(\OXModule\StructClass\SOAPStringMapMap $userAttributes = null)
    {
        if (is_null($userAttributes) || (is_array($userAttributes) && empty($userAttributes))) {
            unset($this->userAttributes);
        } else {
            $this->userAttributes = $userAttributes;
        }
        return $this;
    }
    /**
     * Get writeDatabase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \OXModule\StructClass\Database|null
     */
    public function getWriteDatabase()
    {
        return isset($this->writeDatabase) ? $this->writeDatabase : null;
    }
    /**
     * Set writeDatabase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \OXModule\StructClass\Database $writeDatabase
     * @return \OXModule\StructClass\Context
     */
    public function setWriteDatabase(\OXModule\StructClass\Database $writeDatabase = null)
    {
        if (is_null($writeDatabase) || (is_array($writeDatabase) && empty($writeDatabase))) {
            unset($this->writeDatabase);
        } else {
            $this->writeDatabase = $writeDatabase;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \OXModule\StructClass\Context
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
