<?php

namespace Signicat\DocumentServiceV3_API\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for lookup-task StructType
 * @subpackage Structs
 */
class Lookup_task extends AbstractStructBase
{
    /**
     * The lookup_task_id
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $lookup_task_id;
    /**
     * The provider
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $provider;
    /**
     * The orgnr
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $orgnr;
    /**
     * Constructor method for lookup-task
     * @uses Lookup_task::setLookup_task_id()
     * @uses Lookup_task::setProvider()
     * @uses Lookup_task::setOrgnr()
     * @param string $lookup_task_id
     * @param string $provider
     * @param string $orgnr
     */
    public function __construct($lookup_task_id = null, $provider = null, $orgnr = null)
    {
        $this
            ->setLookup_task_id($lookup_task_id)
            ->setProvider($provider)
            ->setOrgnr($orgnr);
    }
    /**
     * Get lookup_task_id value
     * @return string
     */
    public function getLookup_task_id()
    {
        return $this->{'lookup-task-id'};
    }
    /**
     * Set lookup_task_id value
     * @param string $lookup_task_id
     * @return \Signicat\DocumentServiceV3_API\StructType\Lookup_task
     */
    public function setLookup_task_id($lookup_task_id = null)
    {
        // validation for constraint: string
        if (!is_null($lookup_task_id) && !is_string($lookup_task_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lookup_task_id, true), gettype($lookup_task_id)), __LINE__);
        }
        $this->lookup_task_id = $this->{'lookup-task-id'} = $lookup_task_id;
        return $this;
    }
    /**
     * Get provider value
     * @return string
     */
    public function getProvider()
    {
        return $this->provider;
    }
    /**
     * Set provider value
     * @uses \Signicat\DocumentServiceV3_API\EnumType\Lookup_provider::valueIsValid()
     * @uses \Signicat\DocumentServiceV3_API\EnumType\Lookup_provider::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $provider
     * @return \Signicat\DocumentServiceV3_API\StructType\Lookup_task
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: enumeration
        if (!\Signicat\DocumentServiceV3_API\EnumType\Lookup_provider::valueIsValid($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Signicat\DocumentServiceV3_API\EnumType\Lookup_provider', is_array($provider) ? implode(', ', $provider) : var_export($provider, true), implode(', ', \Signicat\DocumentServiceV3_API\EnumType\Lookup_provider::getValidValues())), __LINE__);
        }
        $this->provider = $provider;
        return $this;
    }
    /**
     * Get orgnr value
     * @return string
     */
    public function getOrgnr()
    {
        return $this->orgnr;
    }
    /**
     * Set orgnr value
     * @param string $orgnr
     * @return \Signicat\DocumentServiceV3_API\StructType\Lookup_task
     */
    public function setOrgnr($orgnr = null)
    {
        // validation for constraint: string
        if (!is_null($orgnr) && !is_string($orgnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgnr, true), gettype($orgnr)), __LINE__);
        }
        $this->orgnr = $orgnr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Signicat\DocumentServiceV3_API\StructType\Lookup_task
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
